/*************************************************************************/
/*                                                                       */
/*                Centre for Speech Technology Research                  */
/*                     University of Edinburgh, UK                       */
/*                         Copyright (c) 1996                            */
/*                        All Rights Reserved.                           */
/*                                                                       */
/*  Permission to use, copy, and modify this software and its            */
/*  documentation for research, educational and individual use only, is  */
/*  hereby granted without fee, subject to the following conditions:     */
/*   1. The code must retain the above copyright notice, this list of    */
/*      conditions and the following disclaimer.                         */
/*   2. Any modifications must be clearly marked as such.                */
/*   3. Original authors' names are not deleted.                         */
/*  This software may not be used for commercial purposes without        */
/*  specific prior written permission from the authors.                  */
/*                                                                       */
/*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK        */
/*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING      */
/*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT   */
/*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE     */
/*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES    */
/*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN   */
/*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,          */
/*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF       */
/*  THIS SOFTWARE.                                                       */
/*                                                                       */
/*************************************************************************/
/*                    Author :  Paul Taylor                              */
/*                    Date   :  February 1996                            */
/*                    Release:  0.9                                      */
/*-----------------------------------------------------------------------*/
/*                    Event RFC Synthesis                                */
/*                                                                       */
/*=======================================================================*/

#include "EST.h"
#include "EST_rfc.h"

int main (int argc, char *argv[])
{
    EST_Track fz, nfz;
    EST_Stream ev_lab;
    EST_Option al, op;
    EST_StrList files;
    EST_String out_file("-"), ev_format;
    float shift;
    const float default_frame_shift = 0.01; // i.e 10ms intervals
    
    print_help(argc, argv);

    parse_command_line(argc, argv, "-color:s -f:i -fmax:f -fmin:f -noconn \n\
		      -o:s -otype:s -ops -s:f", files, al);

    out_file = al.present("-o") ? al.val("-o") : (EST_String)"-";
    init_lib_ops(al, op);

    ev_lab.load(files.first(), "", 2);

    if (read_ev_fields(ev_lab) == -1)
	exit(0);

    shift = al.present("-s") ? al.fval("-s") : default_frame_shift;

    cout << "stream name " << ev_lab.stream_name() << endl;

    if (ev_lab.stream_name() == "tilt_event")
    {
	ev_lab = tilt_to_rfc(ev_lab);
	validate_rfc_stream(ev_lab);
	print_rfc2_events(ev_lab);
    }

    validate_rfc_stream(ev_lab);

    fz = rfc_to_track(ev_lab, shift, al.present("-noconn"));

    if (al.present("-fmax"))
	fz.amax = al.fval("-fmax");
    if (al.present("-fmin"))
	fz.amin = al.fval("-fmin");
    fz.color = al.val("-color", 0);		

    fz.save(out_file, al.val("-otype"));
    return 0;
}

void override_lib_ops(EST_Option &a_list, EST_Option &al)
{
    // general options
    a_list.override_val("sample_rate", al.val("-f", 0));
}

void print_help(int argc, char *argv[])
{
    for (int i = 0; i < argc; ++i)
	if (strncmp(argv[i],"-help", 2) == 0)
	{
	    cout << "Usage:\n";
	    cout << "event_synth <input file> <output file> <options>\n";
	    cout << "use \"-\" to make input and output files stdin/out\n";
	    cout << "-h      options help\n";
	    cout << "-color  color of output F0 file\n";
	    cout << "-f      sample freq (useful for xmg files)\n";
	    cout << "-fmax   max F0 value in output file\n";
	    cout << "-fmin   min F0 value in output file\n";
	    cout << "-noconn don't create connections in output\n";
	    cout << "-otype  output file type\n";
	    cout << "-ops    print system options\n";
	    cout << "-s      frame shift (secs) in F0 contour\n";
	    exit (0);
	}
}
