#include "cdebug.h"
#include "combine.h"
#include "gdfonts.h"
#include "count.h"

#include <bigplus.h>

/* protos */
static void add1toData _Declare ((char *buf));
/*
**  rwCounterDataFile()
**  function to read and write counter data from a flat file. the function
**  does the kernel locking on the file.
**
**  RCS
**      $Revision$
**      $Date$
**  Return Values:
**      returns the buffer containing the counter digits in case of success.
**      in case of failure of some sort, the routine does not return, it
**      writes the error message image to the browser and exits with 0.
**
**  Parameters:
**
**
**  Side Effects:
**      the content of the counter datafile is modified.
**
**  Limitations and Comments:
**      The buffer returned points to a malloc'd space. the caller is
**      responsible to free this memory.
**
**  Development History:
**      who                  when           why
**      ma_muquit@fccc.edu   Oct-11-1997    first cut
*/

char *rwCounterDataFile(filepath,
                        ignore_site,
                        use_st,
                        start_value,
                        do_increment)
char
    *filepath;      /* full datafile path */

int
    ignore_site;    /* ignore this site or not */

int
    use_st;         /* use start value or not */

int
    start_value;    /* start value, used if use_st is true */

int
    do_increment;   /* should be counter be incremented */

{
    int
        length,
        n,
        fd;

    char
        tmpbuf[1024],
        *dbuf=(char *) NULL;

    *tmpbuf='\0';

    /*
    ** open the file
    */
    Debug2("filepath=%s",filepath,0);
#ifdef SYS_WIN32
        fd=sopen(filepath,_O_RDWR|_O_CREAT,_SH_DENYWR,_S_IREAD|_S_IWRITE);
#else
        fd=open(filepath,O_RDWR|O_CREAT,0644);
#endif

    if (fd < 0) /* open failed */
    {
        if (Gauto_file_creation == 1)
        {
            if (CheckFile(filepath) != 0)
            {
                (void) sprintf(tmpbuf,
                       "Could not create data file: \"%s\"",filepath);
            }
            else
            {
                (void) sprintf (tmpbuf,
                       "Could not write to counter file: \"%s\"",filepath);
            }
        }
        else
        {
            (void) sprintf (tmpbuf,
                   "Could not write to counter file: \"%s\"",filepath);
        }
        Warning(tmpbuf);
        PrintHeader();
        StringImage(tmpbuf);
        exit(0);
    }

    /*
    ** lock the file
    */
#ifdef SYS_UNIX
        SetLock(fd);
#endif
    
    /*
    ** try to read from file, rewind it first
    */
    lseek(fd,0L,0);

    /*
    ** malloc for dbuf. If malloc fails, we'll be outta here
    */
    dbuf=(char *) cMalloc(MAX_DIGITS*sizeof(char));
    memset(dbuf,0,MAX_DIGITS);
    n=read(fd,dbuf,MAX_DIGITS);

    Debug2("Bytes read=%d",n,0);
    if (n > 0)  /* read something */
    {
        /*
        ** if the content of the datafile has anything but digit, replace
        ** the content with 1. If the content has digits and non-digits,
        ** null terminate at the first non-digit character
        */
        cleanBuf(dbuf,n,&length);
        Debug2("after cleaing: %s length=%d",dbuf,length);

        if ((*dbuf == '\0') || (strcmp(dbuf,"0") == 0))
        {
            (void) strcpy(dbuf,"1");
            length=1;
        }
        else
        {
            /*
            ** now add 1 to the buffer. note: there's no fear to overflow 
            ** int buffer. We can have digits as big as MAX_DIGITS long.
            ** the big number adding routines are from GNU bc library
            */

            if (do_increment == True)
                add1toData(dbuf);
        }
        if (ignore_site == False)
        {
            lseek(fd,0L,0);
            (void) write(fd,dbuf,strlen(dbuf));
        }
    }
    else
    {
        if (use_st == True)
        {
            if (start_value <= 0)
                start_value=1;

            (void) sprintf(dbuf,"%d",start_value);
            (void) lseek(fd,0L,0);
            (void) write(fd,dbuf,strlen(dbuf));
        }
    }
    (void) close(fd);   /* unlocks as well */
    
#ifdef SYS_UNIX
        UnsetLock(fd);
#endif

    return (dbuf);
}


/*
** add 1 to a very large number (80 digit long max in our case)
** uses the bigplus (I named it) library from GNU bc 
*/

/* buf is changed */
static void add1toData(buf)
char *buf;
{
    bc_num
        n1,
        n2,
        result;

    char
        tbuf[2];

    Debug2("buf in add1toData()=%s",buf,0);
    (void) strcpy(tbuf,"1");
    n1=new_num(MAX_DIGITS-2,0);
    n2=new_num(MAX_DIGITS-2,0);
    result=new_num(MAX_DIGITS,0);

    str2num(&n1,buf,0);
    str2num(&n2,tbuf,0);

    bc_add(n1,n2,&result,0);
    (void) strcpy(buf,num2str(result));

    free_num(&n1);
    free_num(&n2);
    free_num(&result);
}

