
import java.sql.*;


/**
 * test nested statements
 *
 */
public class t0024
{
   static public void main(String args[])
      throws SQLException, java.lang.ClassNotFoundException,
      java.lang.Exception
   {
      boolean passed = true;
      Float   d[] = {
         new Float(-1.0),
         new Float(1234.543),
         new Float(0.0),
         new Float(1),
         new Float(-2.0),
         new Float(0.14),
         new Float(0.79),
         new Float(1000000.12345),
         new Float(-1000000.12345),
         new Float(1000000),
         new Float(-1000000),
         new Float(3.4E+38),
         new Float(3.4E-38)
      };

      System.out.println("test using a real as a primary key");

      // open the database
      Class.forName("com.internetcds.jdbc.tds.Driver");

      int         i;
      int         count    = 0;
      Connection  cx       = Common.getConnection();
      Statement   stmt     = cx.createStatement();

      try
      {
         stmt.executeUpdate("drop table t0024");
      }
      catch (SQLWarning e)
      {
         if (! (e.getMessage().startsWith("Cannot drop the table 't0024', because it does")))
         {
            throw e;
         }
      }

      count = stmt.executeUpdate(""
                                 + "create table t0024                  "
                                 + "  (pk   real not null,             "
                                 + "   type char(30) not null,          "
                                 + "   b    bit,                        "
                                 + "   str  char(30) not null,          "
                                 + "   t    datetime default getdate(), "
                                 +"    primary key (pk, type))    ");
      System.out.println("Creating table affected " + count + " rows");

      PreparedStatement  pStmt = cx.prepareStatement(
         "insert into t0024 (pk, type, b, str) values(?, 'prepared', 0, ?)");



      for(i=0; i<d.length; i++)
      {
         {
            pStmt.setFloat(1, d[i].floatValue());
            pStmt.setString(2, (d[i]).toString());
            pStmt.executeUpdate();
         }

         {
            stmt.executeUpdate(""
                               + "insert into t0024        "
                               + " (pk, type, b, str)      "
                               + " values("
                               + "   " + d[i] + ",         "
                               + "       'adhoc',          "
                               + "       1,                "
                               + "   '" + d[i] + "')       ");
         }
      }

      passed = true;

      ResultSet  rs = stmt.executeQuery("select * from t0024 where type='prepared' order by t");
      i=0;
      while(rs.next())
      {
         boolean  same = d[i].toString().equals(""+rs.getFloat("pk"));

         System.out.println(""
                            + same + " "
                            + rs.getObject(1) + " "
                            + rs.getObject(2) + " "
                            + rs.getObject(3) + " "
                            + rs.getObject(4) + " ");
         passed = passed && same;
         i++;
      }
      passed = passed && i==d.length;

      rs = stmt.executeQuery("select * from t0024 where type='adhoc' order by t");
      i=0;
      while(rs.next())
      {
         boolean  same = d[i].toString().equals(""+rs.getFloat("pk"));
         System.out.println(""
                            + same + " "
                            + rs.getObject(1) + " "
                            + rs.getObject(2) + " "
                            + rs.getObject(3) + " "
                            + rs.getObject(4) + " ");
         passed = passed && same;
         i++;
      }
      passed = passed && i==d.length;

     System.out.println("\n" + (passed ? "Passed" : "Failed") 
                        + " t0024.\n");
      System.exit(passed ? 0 : 1);
   }
}

