/*
 *  Sarien AGI :: Copyright (C) 1999 Dark Fiber 
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __AGI_MENU
#define __AGI_MENU

#ifdef __cplusplus
extern "C"{
#endif

typedef struct AGI_MENU
{
	struct	AGI_MENU	*next;		/* next along */
	struct	AGI_MENU	*down;		/* next menu under this */
	UINT8				enabled;	/* enabled or disabled */
	UINT8				event;		/* menu event */
	UINT8				*text;		/* text of menu item */
} AGI_MENU;

extern	AGI_MENU	*menu;

extern	void		init_menus(void);
extern	void		deinit_menus(void);
extern	void		add_menu(UINT8 *message);
extern	void		add_menu_item(UINT8 *message, UINT8 code);
extern	void		submit_menu(void);

extern	void		do_menus(void);

#ifdef __cplusplus
};
#endif
#endif
