/*
 *  Sarien AGI :: Copyright (C) 1999 Dark Fiber 
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __AGI_VIEW
#define __AGI_VIEW

#ifdef __cplusplus
extern "C"{
#endif

typedef struct VIEW_CEL
{
	UINT8	height;
	UINT8	width;
	UINT8	transparency;
	UINT8	mirror_loop;
	UINT8	mirror;
	UINT8	*data;
} VIEW_CEL;

typedef struct VIEW_LOOP
{
	UINT8		num_cels;
	VIEW_CEL	*cel;
} VIEW_LOOP;

typedef struct AGI_VIEW
{
	UINT8		num_loops;
	VIEW_LOOP	*loop;
	UINT8		*descr;
	UINT8		*rdata;
} AGI_VIEW;

typedef struct AGI_VIEW_TABLE
{
	AGI_VIEW	*view;

	UINT8		step_time;
	UINT8		step_time_count;
	UINT8		x_pos;
	UINT8		y_pos;
	UINT8		current_view;
	UINT8		current_loop;
	UINT8		num_loops;
	VIEW_LOOP	*loop;
	UINT8		cur_cel;
	UINT8		num_cels;
	VIEW_CEL	*cel;
	UINT8		*bg_scr;
	UINT8		*bg_pri;
	UINT16		bg_x;
	UINT16		bg_y;
	UINT16		bg_x_size;
	UINT16		bg_y_size;
	UINT16		x_size;
	UINT16		y_size;
	UINT8		step_size;
	UINT8		cycle_time;
	UINT8		cycle_time_count;
	UINT8		direction;
	UINT8		motion;
	UINT8		cycle_status;
	UINT8		priority;
	UINT16		flags;
	UINT8		parm1;
	UINT8		parm2;
	UINT8		parm3;
	UINT8		parm4;
} AGI_VIEW_TABLE;

typedef struct VIEW_LIST
{
	struct VIEW_LIST	*up;
	struct VIEW_LIST	*down;
	AGI_VIEW_TABLE		*vt;
} VIEW_LIST;

#define DRAWN			0x0001
#define IGNORE_BLOCKS		0x0002
#define FIXED_PRIORITY		0x0004
#define IGNORE_HORIZON		0x0008
#define UPDATE			0x0010
#define CYCLING			0x0020
#define ANIMATED		0x0040
#define MOTION			0x0080
#define ON_WATER		0x0100
#define IGNORE_OBJECTS		0x0200
#define ON_LAND			0x0800
#define FIX_LOOP		0x2000


extern	AGI_VIEW_TABLE	view_table[];
extern	AGI_VIEW	views[];


void	init_view_table	(void);
void	unload_view	(UINT16);
UINT16	decode_view	(UINT16);
void	add_view_table	(UINT8, UINT8);
void	set_loop	(UINT8, UINT8);
void	set_cel		(UINT8, UINT8);
void	add_to_pic	(UINT8, UINT8, UINT8, UINT8, UINT8, UINT8, UINT8);
void	reset_views	(void);
void	reset_view	(UINT16);
void	calc_direction	(UINT8);
void	draw_obj	(UINT8);

#ifdef __cplusplus
};
#endif
#endif
