/*
 * (C) Copyright Keith Visco 1999  All rights reserved.
 *
 * The contents of this file are released under an Open Source 
 * Definition (OSD) compliant license; you may not use this file 
 * execpt in compliance with the license. Please see license.txt, 
 * distributed with this file. You may also obtain a copy of the
 * license at http://www.clc-marketing.com/xslp/license.txt
 *
 * The program is provided "as is" without any warranty express or
 * implied, including the warranty of non-infringement and the implied
 * warranties of merchantibility and fitness for a particular purpose.
 * The Copyright owner will not be liable for any damages suffered by
 * you as a result of using the Program. In no event will the Copyright
 * owner be liable for any special, indirect or consequential damages or
 * lost profits even if the Copyright owner has been advised of the
 * possibility of their occurrence.
 *
 * 
 */
package com.kvisco.xsl;

import org.w3c.dom.*;

/**
 * Represents an AndExpr
 * @author <a href="mailto:kvisco@ziplink.net">Keith Visco</a>
**/
public class AndExpr implements Expr {

    
    private static String AND = " and ";
    private static String NULL = "null";
    
    private Expr leftExpr = null;
    private Expr rightExpr = null;
    
    
      //---------------/
     //- Constructor -/
    //---------------/
    
    public AndExpr(Expr leftSideExpr, Expr rightSideExpr) {
        leftExpr = leftSideExpr;
        rightExpr = rightSideExpr;
    } //-- AndExpr 
    
      //------------------/
     //- Public Methods -/
    //------------------/
    
    /**
     * Returns the type of Expr this Expr represents
     * @return the type of Expr this Expr represents
    **/
    public short getExprType() {
        return Expr.BOOLEAN;
    } //-- getExprType
    
    /**
     * Evaluates this Expr using the given context Node and ProcessorState
     * @param context the current context Node
     * @param ps the ProcessorState that contains the current processing 
     * environment
     * @return the ExprResult
    **/
    public ExprResult evaluate(Node context, ProcessorState ps) 
        throws InvalidExprException
    {
        if ((leftExpr == null) || (rightExpr == null))
            return BooleanResult.FALSE_RESULT;
            
        if (!leftExpr.evaluate(context, ps).booleanValue())
            return BooleanResult.FALSE_RESULT;
            
        return new BooleanResult(rightExpr.evaluate(context, ps));
    } //-- evaluate
    
    
    /**
     * Returns the String representation of this AndExpr
     * @return the String representation of this AndExpr
    **/
    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (leftExpr != null) sb.append(leftExpr.toString());
        else sb.append(NULL);
        sb.append(AND);
        if (rightExpr != null) sb.append(rightExpr.toString());
        else sb.append(NULL);
        return sb.toString();
    } //-- toString
    /* */
} //-- Expr