/* -*- mode: C++; tab-width: 4 -*- */
/* ================================================================================== */
/* Copyright (c) 1998-1999 3Com Corporation or its subsidiaries. All rights reserved. */
/* ================================================================================== */

#ifndef _BANK_MC68328_H_
#define _BANK_MC68328_H_

#include "EmulatorTypes.h"		// RGBType
#include "UART.h"				// UART::State

class SessionFile;

class MC68328Bank
{
	public:
		static void				Initialize		(void);
		static void				Reset			(void);
		static void				Save			(SessionFile&);
		static void				Load			(SessionFile&);
		static void				Dispose			(void);

		static void				InstallHandlers	(void);

		static uae_u32			GetLong			(uaecptr iAddress);
		static uae_u32			GetWord			(uaecptr iAddress);
		static uae_u32			GetByte			(uaecptr iAddress);
		static void				SetLong			(uaecptr iAddress, uae_u32 iLongValue);
		static void				SetWord			(uaecptr iAddress, uae_u32 iWordValue);
		static void				SetByte			(uaecptr iAddress, uae_u32 iByteValue);
		static int				ValidAddress	(uaecptr iAddress, uae_u32 iSize);
		static uae_u8*			GetRealAddress	(uaecptr iAddress);

		static void				Cycle					(Bool sleeping);
		static void				CycleSlowly				(Bool sleeping);
		static uae_s32			GetInterruptLevel		(void);
		static uae_s32			GetInterruptBase		(void);
		static void				ButtonEvent				(Bool iButton_IsDown, uae_s32 iButton);
		static void				HotSyncEvent			(Bool iButton_IsDown);
		static int				GetLCDDepth				(void);
		static int				GetLCDRowBytes			(void);
		static int				GetLCDWidth				(void);
		static int				GetLCDHeight			(void);
		static uaecptr			GetLCDStartAddr			(void);
		static int				GetLCDPalette			(RGBType* scrPalette);
		static int				GetLCDOffset			(void);
		static Bool				LCDIsOn					(void);
		static Bool				BacklightIsOn			(void);
		static void				TurnSoundOff			(void);
		static uae_u32			GetDynamicHeapSize		(void);
		static uae_u32			GetROMSize				(void);

		static Bool				CanStop					(void);

		static void				UpdateInterrupts		(void);
		static void				UpdatePortDInterrupts	(void);
		static void				UpdateRTCInterrupts		(void);

		static void				UARTStateChanged		(Bool sendTxData);
		static void				UpdateUARTState			(Bool refreshRxData);
		static void				UpdateUARTInterrupts	(const UART::State& state);
		static void				MarshalUARTState		(UART::State& state);
		static void				UnmarshalUARTState		(const UART::State& state);

	private:
		static void				InvalidAccess	(uaecptr iAddress, long size, Bool forRead);
		static void				PreventedAccess	(uaecptr iAddress, long size, Bool forRead);

		friend class MC68328Reg;	// Calls MC68328Bank::InvalidAccess
};


#endif /* _BANK_MC68328_H_ */
  
  
