/* -*- mode: C++; tab-width: 4 -*- */
/* ================================================================================== */
/* Copyright (c) 1998-1999 3Com Corporation or its subsidiaries. All rights reserved. */
/* ================================================================================== */

#ifndef _SKINS_H_
#define _SKINS_H_

#include "EmulatorTypes.h"		// DeviceType, ScaleType

enum SkinElementType
{
	kElement_First,

	kElement_PowerButton = kElement_First,
	kElement_UpButton,
	kElement_DownButton,
	kElement_App1Button,
	kElement_App2Button,
	kElement_App3Button,
	kElement_App4Button,
	kElement_CradleButton,
	kElement_Antenna,
	kElement_ContrastButton,
	kElement_Touchscreen,
	kElement_LCD,

	kElement_NumElements,

	kElement_Frame	= -1,
	kElement_None	= -2
};

	// Pre-increment operator
inline void	operator++(SkinElementType& x)
{
	x = SkinElementType (x + 1);
}

	// Post-increment operator
inline void	operator++(SkinElementType& x, int)
{
	x = SkinElementType (x + 1);
}

	// Pre-decrement operator
inline void	operator--(SkinElementType& x)
{
	x = SkinElementType (x - 1);
}

	// Post-decrement operator
inline void	operator--(SkinElementType& x, int)
{
	x = SkinElementType (x - 1);
}


typedef string				SkinName;
typedef vector<SkinName>	SkinNameList;


SkinName		SkinGetSkinName			(DeviceType);
void			SkinGetSkinNames		(DeviceType, SkinNameList&);

void			SkinSetSkin				(void);
void			SkinSetSkin				(DeviceType, ScaleType scale, const SkinName&);

const char*		SkinGetResourceName		(void);
const char*		SkinGetResourceName		(ScaleType scale);
void			SkinGetImageAsJPEG		(const void*&, long&);
void			SkinGetImageAsJPEG		(ScaleType scale, const void*&, long&);
void			SkinDoneWithImage		(const void*);
RGBType			SkinGetBackgroundColor	(void);
RGBType			SkinGetHighlightColor	(void);

SkinElementType	SkinTestPoint			(const PointType& windowPt);
PointType		SkinWindowToTouchscreen	(const PointType& windowPt);
PointType		SkinTouchscreenToWindow	(const PointType& lcdPt);
RectangleType	SkinGetElementRect		(SkinElementType);
AbsRectType		SkinGetAbsElementRect	(SkinElementType);

PointType		SkinScaleDown			(const PointType&);
RectangleType	SkinScaleDown			(const RectangleType&);
AbsRectType		SkinScaleDown			(const AbsRectType&);

PointType		SkinScaleUp				(const PointType&);
RectangleType	SkinScaleUp				(const RectangleType&);
AbsRectType		SkinScaleUp				(const AbsRectType&);

#if 0
Bool			SkinValidSkin			(DeviceType, const SkinName&);
#endif

#endif	// _SKINS_H_
