;; bootconfig-convert-lilotemplate.el - Convert lilo.conf template.
;;
;; Makes an easy-to-edit C comment into a tricky punctuated and escaped
;; CPP macro.
;;
;; Brought to you by the "Why X?Emacs is better than vi" ministry.
;;
;; 2000.02.04 - Karl M. Hegbloom <karlheg@debian.org>
;;
;; Yes, a shell filter written in Perl could do the same thing from `vi'.

(defun bc-convert-lilotemplate ()
  "Convert the C comment containing the `lilo.conf' template into a CPP macro.
Edit the template using `M-x c-comment-edit', which will put you in a
`text-mode' buffer with the comment delimiters stripped.  Finish
editting with `C-c C-c', then with the cursor inside the template
comment, call this function with `M-x bc-convert-lilotemplate'."
  (interactive)
  (let ((buf (current-buffer))
	(tbuf nil)
	(beg (progn
	       (re-search-backward "/\\*")
	       (forward-line 1)
	       (point)))
	(end (progn
	       (re-search-forward "\\*/")
	       (beginning-of-line)
	       (point))))
    (with-temp-buffer
      (setq tbuf (current-buffer))
      (insert (buffer-substring beg end buf))
      (goto-char (point-min))
      ;; Remove the " * " from the C comment.
      (while (and (not (eobp))
		  (re-search-forward " +\\*+ *" nil t))
	(replace-match ""))
      ;; Escape any double quote marks.
      (goto-char (point-min))
      (while (and (not (eobp))
		  (re-search-forward "\"" nil t))
	(replace-match "\\\\\""))
      ;; Wrap each line in quotes, with a \n embedded at the end of
      ;; each line, and a \ for CPP line continuation.
      (goto-char (point-min))
      (while (not (eobp))
	(insert "\"")
	(end-of-line)
	(insert "\\n\" \\")
	(forward-line 1))
      (set-buffer buf)
      (re-search-forward "^#define BC_LILOTEMPLATE")
      (mark-end-of-line 1)
      (delete-region (point) (mark))
      (end-of-line)
      (insert " \\")
      (forward-line 1)
      (delete-region (point) (save-excursion
			       (re-search-forward "^static int run_lilo")
			       (forward-line -1)
			       (point)))
      (insert (buffer-substring (point-min tbuf) (point-max tbuf) tbuf))
      (re-search-forward "^static int run_lilo")
      (forward-line -2)
      (end-of-line)
      (delete-backward-char 2)
      (forward-line 1))))
