/*
 * installer/map.c
 * 
 * Stuff to create the map file for Choose-OS.
 *
 * Copyright (c) Tuomo Valkonen 1996-1998.
 */
 
#include<stdio.h>
#include<strings.h>
#include<sys/types.h>
#include<sys/stat.h>
#include<fcntl.h>
#include<errno.h>
#include<linux/fs.h>
 
#include<chos/chos.h>
#include<chos/main.h>
#include<chos/image.h>
#include<chos/install.h>
#include<chos/map.h>
#include<chos/linux.h>

/*
 * Data...
 */
GEOMETRY 	mapgeo;			/* Map file device geometry 	*/
int		mapsz;			/* Map size			*/
MF_KernelSector**map=NULL;		/* The map			*/
MF_HeaderSector*mh=NULL;
MF_ImageSector*im=NULL;

void map_initialize(void)
{
				
	if(!(map=(MF_KernelSector**)malloc(sizeof(void*)*2)))
		die(errno,NULL);
	
	if(!(map[0]=(MF_KernelSector*)malloc(SECTORSIZE*2)))
		die(errno,NULL);
	
	map[1]=map[0]+1;

	mapsz=2;
	memset(map[0],0,SECTORSIZE*2);
	map[0]->next_map=1;
	
	mh=(MF_HeaderSector*)map[0];
	im=(MF_ImageSector*)map[1];
	
	// Set header
	mh->id[0]='C';mh->id[1]='H';mh->id[2]='O';
	mh->type=CHOS_MAPFILE;
	mh->major=CHOS_MAJOR;mh->minor=CHOS_MINOR;

	// Set default values
	mh->delay=30;
	mh->nimages=0;
	mh->color=7;
	mh->selcolor=7;
	mh->timex=mh->timey=-1;
	mh->timestrx=mh->loady=-1;
	
	return;
}

int resize(int fd,int newsz)
{
	char		byte=255;
	int		size;
	int		oldpos;
	
	if( (oldpos=lseek(fd,0,SEEK_CUR))<0 || 
	    (size=lseek(fd,0,SEEK_END))<0 )
		return -errno;
	
	if(size>newsz)
		ftruncate(fd,newsz);
	else{
		for( ; size<newsz ; size++ ){
			if( write(fd,&byte,1)<1 )
				return -errno;
		}
	}
	
	if(lseek(fd,oldpos,SEEK_SET)<0)
		return -errno;
	
	return 0;
}

//
// Adds a sector to the map file
//
int map_get_sector(MF_KernelSector**ret)
{
	int sector_no;
	int a;

	mapsz++;
	if(!(map=(MF_KernelSector**)realloc(map,mapsz*sizeof(void**))))
		die(errno,NULL);
		
	if(!(map[mapsz-1]=(MF_KernelSector*)malloc(SECTORSIZE)))
		die(errno,NULL);

	memset(map[mapsz-1],0,SECTORSIZE);

	if(ret)
		*ret=map[mapsz-1];
		
	return map[mapsz-2]->next_map=mapsz-1;
}

int finish_map()
{
	int	i,n;
	int	oldsize;
	int	sector_no;
	int	mapfd;
	MF_LinuxFirstSector*s1;
	char 	*cp;
	
	verbose("Updating/building map file...\n");
	
	mapsz*=SECTORSIZE;
	
	if( (mapfd=open(MAPFILE,O_RDWR|O_CREAT,0600))<0)
		die(errno,MAPFILE);
	
	if( (oldsize=lseek(mapfd,0,SEEK_END))<0 || lseek(mapfd,0,SEEK_SET)<0)
		die(errno,MAPFILE);

	if( !get_device(mapfd,&mapgeo) )
		die(errno,MAPFILE);
	
	mh->map_drive=mapgeo.device;

	if(oldsize<mapsz){
		if((i=resize(mapfd,mapsz))<0)
			die(i,"Error resizing mapfile");
	}
	
	// Get the sectors
	for(i=mapsz/SECTORSIZE-1;i>=0;i--){
		if((sector_no=get_addr(mapfd,i,&mapgeo))==0)
			die(-1,"Hole found in map file !!!\n");
	
		if(sector_no<0)
			die(errno,MAPFILE);
	
		if(!verify_bios_read(&mapgeo,sector_no))
			die(-1,"%s might NOT be accessible by thy bios!!!\n",MAPFILE);
	
		if(i==0)
			break;
			
		map[i-1]->next_map=sector_no;
	}
	
	// Save address of first sector for single-shot autoboot
	mh->map_sect1=sector_no;

	// Now, set the linux images point to the correct sector
	for(i=0;i<mh->nimages;i++){
		if(im->images[i].type!=BIT_LINUX)
			continue;
		n=im->images[i].addr;
		s1=(MF_LinuxFirstSector*)map[n];
		im->images[i].addr=map[n-1]->next_map;
		im->images[i].device=mapgeo.device;
		
		// If there's a ramdisk then set it's map sector too...
		if(im->images[i].flags&LINF_INITRD){
			n=s1->rd_map;
			s1->rd_map=map[n-1]->next_map;
		}
	}
	
	// Convert Latin-1 image names to PC character set
	for(i=0;i<mh->nimages;i++){
		cp = im->images[i].name;
		while (*cp != '\0'){
			*cp = latin2ibm[(unsigned char)*cp];
			cp++;
		}
	}
	
	// write it...
	for(i=0;i<mapsz/SECTORSIZE;i++){
		if(write(mapfd,map[i],SECTORSIZE)==SECTORSIZE)
			continue;
			
		if(oldsize!=0)
			die(errno,"Couldn't write map file!\n"
				  "Your old map file may have been corrupted!\n"
				  "The system may be UNBOOTABLE!\n");
		else
			die(errno,"Couldn't write map file");
	}
		
	// truncate it if needed to
	if(oldsize>mapsz)
		ftruncate(mapfd,mapsz);

	close(mapfd);
	
	// return address of first sector.
	return sector_no;
}
