
#include <std.h>

#include "config.h"

#include <fstream>
#include <vector>

struct param
{
	char *param_name;
	char *param_value;
	bool override;
};

struct param valid_params[] = {
	{"description", "1", false},
	{"sort", "4/2", false},
	{"view", "verbose", false},
	{"captris", "0", false},
	{"captris_score", "0", false},
	{NULL, NULL, false}
};

bool writeconfig(void)
{
	string filename;

	filename += getenv("HOME");
	filename += "/";
	filename += ".captrc";

	ofstream CCHandle(filename.c_str());

	if (!CCHandle.is_open())
		return false;

	for (struct param * p = valid_params; p->param_name != NULL; p++)
	{
		CCHandle << p->param_name << "=" << p->param_value << endl;
	}

	return true;
}

bool initconfig(void)
{
	string filename;

	filename += getenv("HOME");
	filename += "/";
	filename += ".captrc";

	ifstream CCHandle(filename.c_str());

	if (!CCHandle.is_open())
		return false;

	string buffer;

	char buf[BUFSIZ], *x;

	while (1)
	{
		CCHandle.getline(buf, BUFSIZ - 1, '\n');

		if (CCHandle.eof() == true)
			break;

		if ((x = strchr(buf, '\n')))
			*x = 0;

		for (x = buf; *x != '=' && *x != 0; x++);

		if (*x == 0)
		{
			printf("initconfig() parse error: %s (must be name=value pair)\n", buf);
			continue;
		}

		*x = 0;

		x++;

		if (*x == 0)
		{
			printf("initconfig() parse error: %s (must be name=value pair)\n", buf);
			continue;
		}

		if (valid_config_param(buf) == false)
		{
			printf("initconfig(): invalid option: %s (do not edit the config yourself)\n", buf);
			continue;
		}

		store_config_param(buf, x);
	}

	return true;
}

char *get_config_string(char *name)
{
	for (struct param * p = valid_params; p->param_name != NULL; p++)
	{
		if (strcmp(name, p->param_name) == 0)
			return p->param_value;
	}

	return NULL;
}

bool set_config_string(char *name, char *val)
{
	for (struct param * p = valid_params; p->param_name != NULL; p++)
	{
		if (strcmp(name, p->param_name) == 0)
		{
			if (p->override == true)
				free(p->param_value);
			else
				p->override = true;
			p->param_value = strdup(val);
			return true;
		}
	}

	return false;
}

bool valid_config_param(char *name)
{
	for (struct param * p = valid_params; p->param_name != NULL; p++)
	{
		if (strcmp(name, p->param_name) == 0)
			return true;
	}

	return false;
}

void store_config_param(char *name, char *val)
{
	for (struct param * p = valid_params; p->param_name != NULL; p++)
	{
		if (strcmp(name, p->param_name) == 0)
		{
			p->param_value = strdup(val);
			return;
		}
	}
}
