
#include <stdio.h>

#include <std.h>

#include <list/colors.h>
#include <parsers/color.h>
#include <parsers/strutl.h>

#include "coreui.h"

#include "acquire.h"
#include "dialogs.h"

#ifdef HAVE_LIBGPM
#include <func/mouse.h>
#endif

#include <vector>

/*
 * Isn't life just full of hacks ? 
 */
Dialog *active_dialog = 0;

Dialog::Dialog()
{
	ly = -1;
	lx = -1;
	sy = -1;
	sx = -1;
	linecount = 0;
	width = 0;
	Initialized = false;
	active_dialog = this;
}

Dialog::~Dialog()
{
	free_memory();
	deinitialize();
	active_dialog = 0;
}

void Dialog::geometry(int _ly, int _lx, int _sy, int _sx)
{
	ly = _ly;
	lx = _lx;
	sy = _sy;
	sx = _sx;
}

void Dialog::addline(string text, void (*keyhandler) (int))
{
	Lines[linecount] = new Entry;
	Lines[linecount]->text = strdup(text.c_str());
	Lines[linecount]->keyhandler = keyhandler;

	linecount++;

	if ((unsigned) ColorCountStrLen((char *) text.c_str()) > width)
		width = ColorCountStrLen((char *) text.c_str());
}

void Dialog::addline(string text)
{
	addline(text, NULL);
}

void Dialog::free_memory()
{
	for (unsigned I = 0; I < linecount; I++)
	{
		free(Lines[I]->text);
		free(Lines[I]);
	}

	linecount = 0;
	width = 0;
}

void Dialog::deinitialize()
{
	if (Initialized)
	{
		ly = -1;
		lx = -1;
		sy = -1;
		sx = -1;
		delete Window;
		Initialized = false;
	}
}


void Dialog::initialize()
{

	if (lx == -1)
		lx = width;
	else if (lx > COLS)
		lx = COLS;

	if (ly == -1)
		if (linecount > (unsigned) LINES)
			ly = LINES;
		else
			ly = linecount + 2;
	else if (ly > LINES)
		ly = LINES;

	if (lx <= (COLS - 2))
		lx += 2;

	if (sy == -1)
		sy = (LINES - ly) / 2;

	if (sx == -1)
		sx = (COLS - lx) / 2;

	Window = new UniqueWindow(ly, lx, sy, sx);

	curs_set(0);
	noecho();
	cbreak();

	Window->ChangeTitle(TitleText);
	Window->Refresh();
	Window->scrollable(false);

	// calibrate the cursor to the first line that has a handler function

	cursor = 0;

	for (unsigned I = 0; I < linecount; I++)
		if (Lines[I]->keyhandler != NULL)
		{
			cursor = I;
			break;
		}

	bound_start = 0;
	bound_end = Window->rows();

	while (bound_end < (cursor + 1))
	{
		bound_start += 1;
		bound_end += 1;
	}
	Initialized = true;
}

void Dialog::drawall()
{
	Window->Erase();

	unsigned int I, K;

	for (I = bound_start, K = 0; I < bound_end; I++, K++)
		drawline(K, I);

	Window->Refresh();
}

void Dialog::drawline(int row, unsigned lkey)
{
	if (lkey == cursor)
		wattrset(Window->body(), A_REVERSE);

	ColorMVPrintW(Window->body(), row, 0, COLOR_BLUE, (lkey == cursor ? A_REVERSE : 0), Lines[lkey]->text);
	for (unsigned int J = ColorCountStrLen(Lines[lkey]->text); J < unsigned (Window->cols()); J++)
		mvwaddch(Window->body(), row, J, ' ');

	wstandend(Window->body());
}

bool Dialog::external_key_handler(int key)
{
	return false;
}

void Dialog::select()
{
	while (1)
	{
#ifdef HAVE_LIBGPM
		int Z = Gpm_Wgetch(Window->body());
#else
		int Z = wgetch(Window->body());
#endif

		switch (Z)
		{
		case -1:
			Lines[cursor]->keyhandler(Z);
			return;

		case -2:
			return;

		case 'q':
		case 'Q':
		case 'x':
		case 'X':
		case 27:
			return;

			// page up
		case KEY_PPAGE:
			if (signed (cursor - 5) < 0)
			{
				bound_start = 0;
				bound_end = Window->rows();
				cursor = 0;
			}
			else
			{
				cursor -= 5;

				if (cursor < bound_start)
				{
					bound_start = cursor;
					bound_end = bound_start + Window->rows();
				}
			}
			drawall();
			break;

			// page down
		case KEY_NPAGE:
			if (signed (cursor + 5) > signed (linecount - 1))
			{
				bound_start = linecount - Window->rows();
				bound_end = linecount;
				cursor = bound_end - 1;
			}
			else
			{
				cursor += 5;

				if (cursor > bound_end)
				{
					bound_end = cursor + 1;
					bound_start = bound_end - Window->rows();
				}
			}
			drawall();
			break;

		case KEY_HOME:
			while (bound_start > 0)
			{
				bound_start -= 1;
				bound_end -= 1;
			}
			cursor = bound_start;
			drawall();
			break;

		case KEY_END:
			while (bound_end < linecount)
			{
				bound_start += 1;
				bound_end += 1;
			}
			cursor = bound_end - 1;
			drawall();
			break;

		case 'j':
		case KEY_UP:
			if (cursor == 0)
				break;

			if (cursor == bound_start)
			{
				bound_start -= 1;
				bound_end -= 1;
			}

			cursor -= 1;
			drawall();
			break;

		case 'k':
		case KEY_DOWN:
			if (cursor == (linecount - 1))
				break;

			if (cursor == (bound_end - 1))
			{
				bound_start += 1;
				bound_end += 1;
			}

			cursor += 1;
			drawall();
			break;

		default:
			if (external_key_handler(Z) == false)
				return;
		}
	}
}

void nullfunc(int x)
{
};
void Dialog::execute()
{
	addline("$7#<--$! q/x will exit ", nullfunc);

	initialize();
	drawall();
	select();
}

unsigned char ui_dialog(int pair, char *title, char *fmt, ...)
{
	string buffer;
	va_list va;

	va_start(va, fmt);

	for (char *p = fmt; *p != 0; p++)
	{
		if (*p == '%' && *(p + 1))
		{
			p++;
			if (*p == '%')
			{
				buffer += '%';
			}
			else if (*p == 's')
			{
				char *s = va_arg(va, char *);
				buffer += s;
			}
		}
		else
			buffer += *p;
	}

	va_end(va);

	Dialog MyDialog;

	MyDialog.title(title);

	char *rep = strdup(buffer.c_str());

	for (char *P = sane_strtok(rep, "\n"); P != NULL; P = sane_strtok(NULL, "\n"))
		MyDialog.addline(P);

	free(rep);

	MyDialog.execute();

	return ' ';
}

#ifdef HAVE_LIBGPM
int Dialog::gpm_handler(Gpm_Event * event)
{
	if (Gpm_StrictSingle(event->type))
	{
		for (unsigned I = bound_start; I < bound_end; I++)
		{
			unsigned K = I - bound_start;

			if (((sy + 2 + K) == event->y) && (sx + 2 <= event->x && event->x <= sx + lx - 1))
			{
				cursor = I;
				drawall();
			}
		}
	}
	else if (Gpm_StrictDouble(event->type))
	{
		for (unsigned I = bound_start; I < bound_end; I++)
		{
			unsigned K = I - bound_start;

			if (((sy + 2 + K) == event->y) && (sx + 2 <= event->x && event->x <= sx + lx - 1))
				return -1;
		}
		return -2;
	}

	return 0;
}
#endif
