#pragma implementation
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <misc.h>
#include "dialog.h"
#include "fcombo.h"
#include "dialog.m"
#include "../diajava/proto.h"

PUBLIC ELM_STR::ELM_STR(const char *_value, const char *_verbose)
{
	value = strdup(_value);
	verbose = strdup(_verbose);
}

PUBLIC ELM_STR::~ELM_STR()
{
	free (value);
	free (verbose);
}

PUBLIC ELM_STR *LIST_STR::getitem(int no)
{
	return (ELM_STR*)ARRAY::getitem(no);
}
#if 0
/*
	Return true if the verbose field is used for the selection.
	This is the case when all the first field are empty.
*/
PUBLIC bool LIST_STR::pickverbose()
{
	bool pickverb = true;
	int n = getnb();
	for (int i=0; i<n; i++){
		ELM_STR *ei = getitem(i);
		const char *val = ei->value;
		if (strcmp(val," ")!=0 && val[0] != '\0'){
			pickverb = false;
			break;
		}
	}
	return pickverb;
}
#endif
/*
	Get the "significative" value associate of one item of the choice list
*/
PUBLIC const char *LIST_STR::getvalue(int no)
{
	const char *ret = "";
	ELM_STR *e = getitem(no);
	if (e != NULL){
		ret = e->value;
	}
	return ret;
}
/* #Specification: FIELD_COMBO / principle
	The FIELD_COMBO class is a string editor with an assist
	hot key. When triggered a list of string is displayed
	and the user is allowed to pick a value from there.
	The value (if selected) will replace the input buffer.
*/
#
PUBLIC FIELD_COMBO::FIELD_COMBO(
	const char *_prompt,
	SSTRING &_str)
	: FIELD_STRING_HELP (_prompt,_str)
{
	opts = new LIST_STR;
	listvalueonly = 0;
}

/* #Specification: FIELD_LIST / principle
	The FIELD_LIST class is a selector editor with an assist
	hot key. When triggered a list of string is displayed
	and the user is allowed to pick a value from there.
	The value (if selected) will replace the input buffer.

	The use may either use the input buffer to type the value or use
	the list, but the input has to come from the list.
*/
#
PUBLIC FIELD_LIST::FIELD_LIST(
	const char *_prompt,
	SSTRING &_str)
	: FIELD_COMBO (_prompt,_str)
{
	listvalueonly = 1;
}

PUBLIC FIELD_COMBO::~FIELD_COMBO()
{
	delete opts;
}

/*
	Add one string option to the combo box pick list
*/
PUBLIC void FIELD_COMBO::addopt(const char *str)
{
	opts->add (new ELM_STR(str,""));
}
/*
	Add one string option to the combo box pick list.
	This time there is two string. The strings will be show in
	the pick list like this

	value verbose
*/
PUBLIC void FIELD_COMBO::addopt(const char *value, const char *verbose)
{
	opts->add (new ELM_STR(value,verbose));
}
PROTECTED void FIELD_COMBO::assist(WINDOW *dialog)
{
	int nbopt = opts->getnb();
	DIALOG dia;
	int nof = 0;
	for (int i=0; i<nbopt; i++){
		ELM_STR *elm = opts->getitem(i);
		const char *val = elm->value;
		dia.new_menuitem (val,elm->verbose);
		if (strcmp(buf,val)==0) nof = i;
	}
	MENU_STATUS ret = dia.editmenu (MSG_U(T_HELPLIST,"Help list")
		,MSG_U(I_HELPLIST,"Pick one value")
		,help_nil
		,nof,0);
	touchwin(stdscr);
	touchwin(dialog);
	if (ret == MENU_OK && nof >=0 && nof < nbopt){
		strcpy (buf,opts->getvalue(nof));
		draw(dialog);
	}
}

PUBLIC void FIELD_COMBO::html_draw(int nof)
{
	char key[100];
	format_htmlkey (key,nof);
	html_printf ("<tr><td>%s<td>",prompt);
	if (readonly){
		html_printf ("%s\n",buf);
	}else{
		if (!listvalueonly){
			html_defvar ("text",key,buf,"size=30 maxlength=256");
		}
		html_defvarcur (key,backup.get());
		int n = opts->getnb();
		if (n > 0){	
			char sel_key[100];
			sprintf (sel_key,"SELECT_%s",key);
			html_defselect (sel_key);
			if (!listvalueonly) html_printf ("<OPTION VALUE=0>\n");
			for (int i=0; i<n; i++){
				int id = i+1;
				const char *vstr = opts->getvalue(i);
				ELM_STR *e = opts->getitem(i);
				if (listvalueonly){
					html_printf ("<OPTION VALUE=%d %s>%s %s\n",id
						,strcmp(buf,vstr)==0 ? "selected" : ""
						,e->value,e->verbose);
				}else{
					#if 0
						html_printf ("<OPTION VALUE=%d>%s\n",id,vstr);
					#else
						html_printf ("<OPTION VALUE=%d>%s %s\n",id
							,e->value,e->verbose);
					#endif
				}
			}
			html_printf ("</SELECT>\n");
		}
	}
}

PUBLIC void FIELD_COMBO::gui_draw (int nof, int &)
{
	diagui_send_Label (prompt);
	if (readonly){
		diagui_send_Label (buf);
		#if 0
			char tmp[1000];
			diagui_sendcmd (P_String,"S%d 30 %s\n",nof,diagui_quote(buf,tmp));
		#endif
	}else if (listvalueonly){
		char tmp[1000];
		diagui_sendcmd (P_Choice,"C%d %s\n",nof,diagui_quote(buf,tmp));
		int n = opts->getnb();
		for (int i=0; i<n; i++){
			ELM_STR *elm = opts->getitem(i);
			char tmp1[1000],tmp2[1000];
			diagui_sendcmd (P_Choice_item,"C%d %s %s\n",nof
				,diagui_quote(elm->value,tmp1)
				,diagui_quote(elm->verbose,tmp2));
		}
	}else{
		char tmp[1000];
		diagui_sendcmd (P_Combo,"C%d 30 %s\n",nof,diagui_quote(buf,tmp));
		int n = opts->getnb();
		for (int i=0; i<n; i++){
			ELM_STR *elm = opts->getitem(i);
			char tmp1[1000],tmp2[1000];
			diagui_sendcmd (P_Combo_item,"C%d %s %s\n",nof
				,diagui_quote(elm->value,tmp1)
				,diagui_quote(elm->verbose,tmp2));
		}
	}
}
PUBLIC void FIELD_COMBO::gui_get(int nof)
{
	strcpy_cut (buf,diagui_getval('C',nof),size);
}

/*
	Get the letter use to define the ID of a field in GUI mode.
*/
PUBLIC char FIELD_COMBO::getidprefix ()
{
	return 'C';
}

PUBLIC int FIELD_COMBO::html_validate(int nof)
{
	int ret = -1;
	char key[100];
	format_htmlkey (key,nof);
	const char *old_val = html_getoldval (key);
	const char *new_val = html_getval (key);
	char sel_key[100];
	sprintf (sel_key,"SELECT_%s",key);
	int sel_val = atoi(html_getval (sel_key));
	fprintf (stderr,"validate combo %s val :%s: old :%s: buf :%s: sel_val %d\n",key,new_val,old_val,buf,sel_val);
	if (strcmp(buf,old_val)==0){
		if (sel_val != 0 || listvalueonly){
			strcpy (buf,opts->getvalue(sel_val-1));
		}else{
			strcpy_cut (buf,new_val,size);
		}
		ret = 0;
	}
	return ret;
}

/*
	Add a combo field to the dialog.
	The object will be destroyed by the dialog itself.
	The object is returned so the caller may add options in the
	pick list.
*/
PUBLIC FIELD_COMBO *DIALOG::newf_combo(
	const char *prompt,
	SSTRING &str)
{
	FIELD_COMBO *s = new FIELD_COMBO(prompt,str);
	add (s);
	return s;
}

/*
	Add a selection field to the dialog.
	The object will be destroyed by the dialog itself.
	The object is returned so the caller may add options in the
	pick list.

	Unlike a combo, the user may not enter anything in it. The value
	must be in the list.
*/
PUBLIC FIELD_LIST *DIALOG::newf_list(
	const char *prompt,
	SSTRING &str)
{
	FIELD_LIST *s = new FIELD_LIST (prompt,str);
	add (s);
	return s;
}

PUBLIC VIRTUAL int FIELD_LIST::post_validate()
{
	int ret = -1;
	int n = opts->getnb();
	for (int i=0; i<n; i++){
		if (strcmp(buf,opts->getvalue(i))==0){
			ret = 0;
			break;
		}
	}
	if (ret == -1){
		xconf_error (MSG_U(E_INLIST,"The value must be taken from the list"));
	}
	return ret;
}

PUBLIC void FIELD_LIST::dokey (
	WINDOW *dialog,
	int ,
	FIELD_MSG &)
{
	if (!is_readonly()) assist(dialog);
}

static SSTRING tmpstr;

/* #Specification: FIELD_ENUM / principle
	A FIELD_ENUM is like a field list, except that the information
	edited is the index (a selector) in the list, while the FIELD_LIST
	edit a string which must have the value of one of the item of the list

	In the FIELD_ENUM, we want to know which elm was choosen.
*/
#
/*
	We do a trick. The contructor for FIELD_LIST need a SSTRING.
	We give a dummy.
	Later when the addopt are done, we will fill the edit buffer
*/
PUBLIC FIELD_ENUM::FIELD_ENUM(
	const char *_prompt,
	int &_sel)
	: FIELD_LIST (_prompt,tmpstr), sel(_sel)
{
	backup_sel = sel;
}

PUBLIC void FIELD_ENUM::restore()
{
	sel = backup_sel;
}
PUBLIC void FIELD_ENUM::reload(const char *dianame, int nof)
{
	const char *s = opts->getvalue(sel);
	if (s == NULL) s = "";
	strcpy (buf,s);
	sendval (dianame,nof,'C',s);
}

PUBLIC void FIELD_ENUM::save()
{
	int n = opts->getnb();
	for (int i=0; i<n; i++){
		if (strcmp(buf,opts->getvalue(i))==0){
			sel = i;
			break;
		}
	}
}	

PUBLIC void FIELD_ENUM::addopt(const char *str)
{
	if (opts->getnb()==sel){
		strcpy (buf,str);
		backup.setfrom(str);
	}
	FIELD_LIST::addopt(str);
}
/*
	Add one string option to the combo box pick list.
	This time there is two string. The strings will be shown in
	the pick list like this

	value verbose
*/
PUBLIC void FIELD_ENUM::addopt(const char *value, const char *verbose)
{
	FIELD_LIST::addopt(value,verbose);
	if (opts->getnb()==sel+1){
		strcpy (buf,opts->getvalue(sel));
		backup.setfrom(buf);
	}
}

/*
	Create a FIELD_ENUM field
*/
PUBLIC FIELD_ENUM *DIALOG::newf_enum(
	const char *prompt,
	int &sel)
{
	FIELD_ENUM *s = new FIELD_ENUM(prompt,sel);
	add (s);
	return s;
}
	
