#pragma interface
#ifndef HOSTINFO_H
#define HOSTINFO_H

enum IPX_PRIMARY_TYPE {
	IPX_PRIMARY_NO=0,
	IPX_PRIMARY_YES=1,
	IPX_PRIMARY_AUTO=2
};

struct IPX_FRAME_INFO{
	int netnum;
	char active;
	char primary;
};

#define NB_IPX_FRAME_TYPE	4

struct IPX_INTER_INFO{
	IPX_FRAME_INFO frames[NB_IPX_FRAME_TYPE];
};
	
struct DEVICE_NAME_INFO{
	char host[20];		// Pseudo host name to access the configuration
	char net[20];		// of the 4 ethernet adaptors.
	char mask[20];		// NAM_ETH?_XXXX
	char bcast[20];
};


#define INTER_MANUAL	0
#define INTER_DHCP		1
#define INTER_BOOTP		2

struct INTER_INFO{
	SSTRING name;
	SSTRING ipaddr;
	SSTRING network;
	SSTRING netmask;
	SSTRING bcast;
	SSTRING others;
	SSTRING device;
	SSTRING module;
	SSTRING modio;
	SSTRING modirq;
	char confmode;		// INTER_xxxxx
	char pcmcia;		// Fixed device or pcmcia
	char enable;		// The adaptor is active ?
	IPX_INTER_INFO ipx;
};

/* #Specification: netconf / number of eth devices
	Linuxconf can configure up to 4 ethernet devices
*/
#define NB_ETH	20


struct HOSTINFO{
	SSTRING hostname;
	int nbdev;				// number of adaptor effectivly configured
	INTER_INFO a[NB_ETH];	// Info on 20 adaptor
};

class IPX_INFO{
	char ipx_active;	// Activate/desactivate the IPX config
	char primary_auto;
	char frame_auto;
	int  internal_netnum;
	int  internal_nodenum;
	HOSTINFO info;
	/*~PROTOBEG~ IPX_INFO */
public:
	IPX_INFO (CONFIG_FILE&f);
	IPX_INFO (void);
	int edit (void);
private:
	void probe_auto (void);
public:
	int save (void);
	int set (const char *dev, SSTRINGS&reconf);
	/*~PROTOEND~ IPX_INFO */
};

#endif
