#include <ctype.h>

/*
	Compile a C string.
*/
char *str_compile (const char *src, char *dst)
{
	while (*src != '\0'){
		if (*src != '\\'){
			*dst++ = *src++;
		}else{
			char carac = *++src;
			src++;
			switch (carac){
			case 'a':
				carac = '\a';
				break;
			case 'b':
				carac = '\b';
				break;
			case 'f':
				carac = '\f';
				break;
			case 'n':
				carac = '\n';
				break;
			case 'r':
				carac = '\r';
				break;
			case 't':
				carac = '\t';
				break;
			case 'v':
				carac = '\v';
				break;
			case '0':
				carac = 0;
				if (*src == 'x' || *src == 'X'){
					src++;
					while (isxdigit(*src)){
						int val = *src++;
						val = toupper(val);
						if (val >= (int)'A'){
							val -= 'A' - 10;
						}else{
							val -= '0';
						}
						carac = (char)(carac * 16 + val);
					}
				}else{
					carac = 0;
					while (*src >= '0' && *src < '8'){
						int val = *src++;
						val -= '0';
						carac = (char)(carac * 8 + val);
					}
				}
			}
			*dst++ = carac;
		}
	}
	*dst = '\0';
	return dst;
}

