#!/bin/sh
# Script shared by accountdelete.sh and accountarchive.sh
# It parses the arguments. It could be used by other scripts called
# by linuxconf.
cd /
usage(){
	echo Invalid or missing argument >&2
	echo expect --uid user-id --name \"full name\" --basehome /home --home home_directory --domain / >&2
}

BASE=/home
DOMAIN=/

while [ $# -ge 2 ]
do
	if [ "$1" = "--uid" ] ; then
		USERID=$2
	elif [ "$1" = "--name" ] ; then
		NAME="$2"
	elif [ "$1" = "--basehome" ] ; then
		BASE=$2
	elif [ "$1" = "--home" ] ; then
		HOMEDIR=$2
	elif [ "$1" = "--domain" ] ; then
		DOMAIN=$2
	elif [ "$1" = "--group" ] ; then
		GROUP=$2
	else
		usage
		exit 1
	fi
	shift
	shift
done

if [ "$USERID" = "" -o "$HOMEDIR" = "" ] ; then
	usage
	exit 1
fi

INBOX=var/spool/mail/$USERID
if [ "$DOMAIN" != "/" ] ; then
	INBOX=var/spool/vmail/$DOMAIN/$USERID
fi

