#include "system.h"
#include "rpmlib.h"

const struct headerTagTableEntry rpmTagTable[] = {
	{ "RPMTAG_NAME", 1000 },
	{ "RPMTAG_VERSION", 1001 },
	{ "RPMTAG_RELEASE", 1002 },
	{ "RPMTAG_EPOCH", 1003 },
	{ "RPMTAG_SERIAL", RPMTAG_EPOCH },
	{ "RPMTAG_SUMMARY", 1004 },
	{ "RPMTAG_DESCRIPTION", 1005 },
	{ "RPMTAG_BUILDTIME", 1006 },
	{ "RPMTAG_BUILDHOST", 1007 },
	{ "RPMTAG_INSTALLTIME", 1008 },
	{ "RPMTAG_SIZE", 1009 },
	{ "RPMTAG_DISTRIBUTION", 1010 },
	{ "RPMTAG_VENDOR", 1011 },
	{ "RPMTAG_GIF", 1012 },
	{ "RPMTAG_XPM", 1013 },
	{ "RPMTAG_LICENSE", 1014 },
	{ "RPMTAG_COPYRIGHT", RPMTAG_LICENSE },
	{ "RPMTAG_PACKAGER", 1015 },
	{ "RPMTAG_GROUP", 1016 },
	{ "RPMTAG_SOURCE", 1018 },
	{ "RPMTAG_PATCH", 1019 },
	{ "RPMTAG_URL", 1020 },
	{ "RPMTAG_OS", 1021 },
	{ "RPMTAG_ARCH", 1022 },
	{ "RPMTAG_PREIN", 1023 },
	{ "RPMTAG_POSTIN", 1024 },
	{ "RPMTAG_PREUN", 1025 },
	{ "RPMTAG_POSTUN", 1026 },
	{ "RPMTAG_FILENAMES", 1027 },
	{ "RPMTAG_FILESIZES", 1028 },
	{ "RPMTAG_FILESTATES", 1029 },
	{ "RPMTAG_FILEMODES", 1030 },
	{ "RPMTAG_FILERDEVS", 1033 },
	{ "RPMTAG_FILEMTIMES", 1034 },
	{ "RPMTAG_FILEMD5S", 1035 },
	{ "RPMTAG_FILELINKTOS", 1036 },
	{ "RPMTAG_FILEFLAGS", 1037 },
	{ "RPMTAG_ROOT", 1038 },
	{ "RPMTAG_FILEUSERNAME", 1039 },
	{ "RPMTAG_FILEGROUPNAME", 1040 },
	{ "RPMTAG_ICON", 1043 },
	{ "RPMTAG_SOURCERPM", 1044 },
	{ "RPMTAG_FILEVERIFYFLAGS", 1045 },
	{ "RPMTAG_ARCHIVESIZE", 1046 },
	{ "RPMTAG_PROVIDENAME", 1047 },
	{ "RPMTAG_PROVIDES", RPMTAG_PROVIDENAME },
	{ "RPMTAG_REQUIREFLAGS", 1048 },
	{ "RPMTAG_REQUIRENAME", 1049 },
	{ "RPMTAG_REQUIREVERSION", 1050 },
	{ "RPMTAG_CONFLICTFLAGS", 1053 },
	{ "RPMTAG_CONFLICTNAME", 1054 },
	{ "RPMTAG_CONFLICTVERSION", 1055 },
	{ "RPMTAG_BUILDROOT", 1057 },
	{ "RPMTAG_EXCLUDEARCH", 1059 },
	{ "RPMTAG_EXCLUDEOS", 1060 },
	{ "RPMTAG_EXCLUSIVEARCH", 1061 },
	{ "RPMTAG_EXCLUSIVEOS", 1062 },
	{ "RPMTAG_RPMVERSION", 1064 },
	{ "RPMTAG_TRIGGERSCRIPTS", 1065 },
	{ "RPMTAG_TRIGGERNAME", 1066 },
	{ "RPMTAG_TRIGGERVERSION", 1067 },
	{ "RPMTAG_TRIGGERFLAGS", 1068 },
	{ "RPMTAG_TRIGGERINDEX", 1069 },
	{ "RPMTAG_VERIFYSCRIPT", 1079 },
	{ "RPMTAG_CHANGELOGTIME", 1080 },
	{ "RPMTAG_CHANGELOGNAME", 1081 },
	{ "RPMTAG_CHANGELOGTEXT", 1082 },
	{ "RPMTAG_PREINPROG", 1085 },
	{ "RPMTAG_POSTINPROG", 1086 },
	{ "RPMTAG_PREUNPROG", 1087 },
	{ "RPMTAG_POSTUNPROG", 1088 },
	{ "RPMTAG_BUILDARCHS", 1089 },
	{ "RPMTAG_OBSOLETENAME", 1090 },
	{ "RPMTAG_OBSOLETES", RPMTAG_OBSOLETENAME },
	{ "RPMTAG_VERIFYSCRIPTPROG", 1091 },
	{ "RPMTAG_TRIGGERSCRIPTPROG", 1092 },
	{ "RPMTAG_COOKIE", 1094 },
	{ "RPMTAG_FILEDEVICES", 1095 },
	{ "RPMTAG_FILEINODES", 1096 },
	{ "RPMTAG_FILELANGS", 1097 },
	{ "RPMTAG_PREFIXES", 1098 },
	{ "RPMTAG_INSTPREFIXES", 1099 },
	{ "RPMTAG_CAPABILITY", 1105 },
	{ "RPMTAG_ORIGFILENAMES", 1107 },
	{ "RPMTAG_BUILDMACROS", 1111 },
	{ "RPMTAG_PROVIDEFLAGS", 1112 },
	{ "RPMTAG_PROVIDEVERSION", 1113 },
	{ "RPMTAG_OBSOLETEFLAGS", 1114 },
	{ "RPMTAG_OBSOLETEVERSION", 1115 },
	{ NULL, 0 }
};

const int rpmTagTableSize = sizeof(rpmTagTable) / sizeof(struct headerTagTableEntry) - 1;
