/* input.h: input functions
 *
 * Copyright (C) 1995-97 Roman Hodek <Roman.Hodek@informatik.uni-erlangen.de>
 *               1996-97 Michael Schlueter <schlue00@marvin.informatik.uni-dortmund.de>
 *
 * This program is free software.  You can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation: either version 2 or
 * (at your option) any later version.
 *
 */

#ifndef _input_h
#define _input_h

/* $Id: input.h,v 1.2 1997/06/21 20:47:44 rnhodek Exp $
 *
 * $Log: input.h,v $
 * Revision 1.2  1997/06/21 20:47:44  rnhodek
 * Added RCS keywords
 *
 * Revision 1.1  1997/06/11 14:36:36  rnhodek
 * Initial revision
 * 
 * Revision 1.1.1.1  1997/06/11 14:36:36  rnhodek
 * Started using CVS for atafdisk
 *
 */

#include "fdisk.h"

/***************************** Prototypes *****************************/

char read_char( char *mesg );
uint read_int( uint low, uint dflt, uint high, enum offset base, char *mesg
               );
int read_line( void);
int read_yesno( char *mesg, int dflt );
int get_partition( int max );

/************************* End of Prototypes **************************/

#endif  /* _input_h */
