########################################################################
##
## The command line parser is generated here.
##
########################################################################

########################################################################
proc b {num} {
  return [string range {                                       }\
	      1 $num]
}
########################################################################
proc genflagParse {opt} {
  global D

  return "      cmd.$D($opt,name)P = TRUE;\n"
}
########################################################################
proc genRangeCheck {opt typ count var b} {
  global D

  set res {}
  if { $D($opt,max)!="oo" } {
    append res [blanks $b]
    append res "check${typ}Lower(\"$opt\", $var, $count, $D($opt,max));\n"
  }
  if { $D($opt,min)!="-oo" } {
    append res [blanks $b]
    append res "check${typ}Higher(\"$opt\", $var, $count, $D($opt,min));\n"
  }
  return $res
}
########################################################################
proc countVal {c} {
  if { $c=="oo" } {
    return -1
  } else {
    return $c
  }
}
########################################################################
proc genXParse {opt typ} {
  global D

  set res "      cmd.$D($opt,name)P = TRUE;\n"

  if { $D($opt,cmax)==1 } {
    ##### zero or one parameter
    append res \
	"[b 6]keep = i;\n"\
	"[b 6]i = get${typ}Opt(argc, argv, i, "\
	                        "&cmd.$D($opt,name), $D($opt,cmin));\n"\
	"[b 6]cmd.$D($opt,name)C = i-keep;\n"

    if { $typ=="Float" || $typ=="Int" } {
      append res \
      [genRangeCheck $opt $typ cmd.$D($opt,name)C &cmd.$D($opt,name) 6]
    }
    return $res
  } 

  ##### possibly more than one parameter
  append res \
      "[b 6]keep = i;\n"\
      "[b 6]i = get${typ}Opts(argc, argv, i, &cmd.$D($opt,name), "\
                           "$D($opt,cmin), [countVal $D($opt,cmax)]);\n"\
      "[b 6]cmd.$D($opt,name)C = i-keep;\n"

  if { $typ=="Float" || $typ=="Int" } {
    append res \
	[genRangeCheck $opt $typ cmd.$D($opt,name)C cmd.$D($opt,name) 6]
  }
  return $res

}
########################################################################
proc genintParse {opt} {
  return [genXParse $opt Int]
}
########################################################################
proc genfloatParse {opt} {
  return [genXParse $opt Float]
}
########################################################################
proc {genchar*Parse} {opt} {
  return [genXParse $opt String]
}
########################################################################
proc genParse {} {
  global D L haveMandatory argvString

  ##-------------------
  set res {}
  append res \
      "Cmdline *\n"\
      "parseCmdline(int argc, char **argv)\n"\
      "\{\n"\
      "  int i, keep;\n"

  if { $haveMandatory } {
    append res "  char missingMandatory = FALSE;\n"
  }

  append res \
      "\n"\
      "  Program = argv\[0\];\n"

  if [info exist argvString] {
    append res \
	"  cmd.$argvString = catArgv(argc, argv);\n"
  }

  append res \
      "  for(i=1, cmd.argc=1; i<argc; i++) \{\n"

  ##-------------------

  ## if there is a Rest command, `--' stops option processing
  if { [info exist D(...,name)] } {
    append res \
	"    if( 0==strcmp(\"--\", argv\[i\]) ) \{\n" \
	"      while( ++i<argc ) argv\[cmd.argc++\] = argv\[i\];\n" \
	"      continue;\n" \
	"    \}\n\n"
  }
    
  foreach opt $L {
    append res \
	"    if( 0==strcmp(\"$opt\", argv\[i\]) ) \{\n" \
	[gen$D($opt,type)Parse $opt] \
	"      continue;\n" \
	"    \}\n\n"
  }

  append res \
      "    if( argv\[i\]\[0\]=='-' ) {\n"\
      "      fprintf(stderr, \"\\n%s: unknown option `%s'\\n\\n\",\n"\
      "              Program, argv\[i\]);\n"\
      "      usage();\n"\
      "    }\n"\
      "    argv\[cmd.argc++\] = argv\[i\];\n"\
      "  \}/* for i */\n\n"\
      "[genCheckMandatory "  "]\n"\
      "  /*@-mustfree*/\n"\
      "  cmd.argv = argv+1;\n"\
      "  /*@=mustfree*/\n"\
      "  cmd.argc -= 1;\n\n"

  #####
  ##### Check of non-option arguments (Rest-command)
  #####
  if { [info exist D(...,name)] } {
    if { $D(...,cmin)>0 } {
      append res \
	  "  if( $D(...,cmin)>cmd.argc ) {\n"\
	  "    fprintf(stderr, \"%s: there should be at least"\
	  " $D(...,cmin) non-option argument(s)\\n\",\n"\
	  "            Program);\n"\
	  "    exit(EXIT_FAILURE);\n"\
	  "  }\n"
    }

    if { ![Infty $D(...,cmax)] } {
      append res \
	  "  if( $D(...,cmax)<cmd.argc ) {\n"\
	  "    fprintf(stderr, \"%s: there should be at most"\
	  " $D(...,cmax) non-option argument(s)\\n\",\n"\
	  "            Program);\n"\
	  "    exit(EXIT_FAILURE);\n"\
	  "  }\n"
    }

  } else {
    ##### no Rest-command
    append res \
	"  if( cmd.argc>0 ) {\n"\
	"    fprintf(stderr, \"%s: There are %d arguments not "\
	"associated with any option\\n\",\n"\
	"            Program, cmd.argc);\n"\
        "    exit(EXIT_FAILURE);\n"\
	"  }\n"
  }

  append res \
      "  /*@-compmempass*/"\
      "  return &cmd;\n"\
      "\}\n"
  return $res
}
