#!/bin/sh
#
#	fhist - file history and comparison tools
#	Copyright (C) 1999 Peter Miller;
#	All rights reserved.
#
#	This program is free software; you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation; either version 2 of the License, or
#	(at your option) any later version.
#
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#
#	You should have received a copy of the GNU General Public License
#	along with this program; if not, write to the Free Software
#	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
#
# MANIFEST: Test the binary files functionality
#

work=/tmp/$$
PAGER=cat
export PAGER

fail()
{
	set +x
	echo 'FAILED test of the binary files functionality' 1>&2
	cd $here
	rm -rf $work
	exit 1
}
pass()
{
	set +x
	echo PASSED 1>&2
	cd $here
	rm -rf $work
	exit 0
}
trap "fail" 1 2 3 15

here=`pwd`
if test $? -ne 0 ; then exit 1; fi
mkdir $work
if test $? -ne 0 ; then exit 1; fi
cd $work
if test $? -ne 0 ; then fail; fi

if [ "$1" != "" ]; then bin=$here/$1/bin; else bin=$here/bin; fi

#
# test the binary files functionality
#
cat > tmp-foo1.uue << 'fubar'
begin 644 tmp-foo1
@3&EN92!/;F4*3&EN90`@5'=O($$*3&EN92!4:')E90H`
`
end
fubar
if test $? -ne 0 ; then fail; fi

cat > tmp-foo2.uue <<  'fubar'
begin 644 tmp-foo2
@3&EN92!/;F4*3&EN90`@5'=O($(*3&EN92!4:')E90H`
`
end
fubar
if test $? -ne 0 ; then fail; fi

uudecode tmp-foo1.uue
if test $? -ne 0 ; then fail; fi

uudecode tmp-foo2.uue
if test $? -ne 0 ; then fail; fi

cat > test.ok << 'fubar'
Files "tmp-foo1" and "tmp-foo2":
1 inserted  1 deleted  2 matched
fubar
if test $? -ne 0 ; then fail; fi

$bin/fcomp -q tmp-foo1 tmp-foo2 > test.out 2> LOG
if test $? -ne 0 ; then cat LOG; fail; fi

diff test.ok test.out
if test $? -ne 0 ; then fail; fi

#
# Only definite negatives are possible.
# The functionality exercised by this test appears to work,
# no other guarantees are made.
#
pass
