#include <sigc++/basic_signal.h>

#ifdef SIGC_CXX_NAMESPACES
namespace SigC
{
#endif //SIGC_CXX_NAMESPACES

Signal_::Impl::Impl():incoming_(),outgoing_() {}
Signal_::Impl::~Impl() {}


Signal_::Signal_()
  :impl(0) 
  {}

Signal_::~Signal_()
  {
    delete impl;
  }

bool Signal_::empty() const
  {
    return (!impl||impl->outgoing_.empty());
  }

void Signal_::clear()
  {
    if (impl)
      impl->outgoing_.clear();
  }

SlotData* Signal_::out_connect(SlotData *sd)
  {
   // we now reference the object
   sd->connect();

   // insert in list
   if (!impl) impl=new Impl();
   impl->outgoing_.insert_direct(impl->outgoing_.begin(),sd->sender());
   return sd;
  }

SlotData* Signal_::in_connect()
  {
   SlotData* sd=manage(new SlotData());
   if (!impl) impl=new Impl();
   impl->incoming_.insert_direct(impl->incoming_.end(),sd->receiver());
   return sd;
  }

#ifdef SIGC_CXX_NAMESPACES
} // namespace
#endif 
