#include <iostream>
#include <string>
#include <sigc++/signal_system.h>

/*
Copyright 1999, Karl Nelson

This program shows how to use slots in STL maps to form callback
maps for menus and such.

*/

#ifdef SIGC_CXX_NAMESPACES
using namespace std;
using namespace SigC;
#endif

typedef Slot1<int,int> MenuSlot;

struct MenuItem
  {
   string   name;
   int      id;
   MenuSlot call;
  };

int fred(int)
  {cout << "call fred"<<endl; return 1;}
int bob(int)
  {cout << "call bob"<<endl; return 1;}
int george(int)
  {cout << "call george"<<endl; return 1;}
  
MenuItem menu[]=
  { {"fred",   1, slot(fred)},
    {"bob",    1, slot(bob)},
    {"george", 1, slot(george)},
    {""      , 0, 0}
  };

int main(int argc,char **argv)
  {
   int i;
   string command;
   while (command!="quit")
    {
     cout << ">>";
     cin >> command;
     for (i=0;menu[i].id!=0;i++)
       if (menu[i].name==command) 
         menu[i].call(i);
    }
   return 0; //compiling is passing
  }


