/*
 * PADEF.C - new definition routines for PANACEA
 *
 * Source Version: 2.0
 * Software Release #92-0043
 *
 */

#include "cpyright.h"
 
#include "panace.h"

#define PA_info_name(tag)  PA_cpp_value_to_name(PA_CPP_INFO, tag)

int
 PA_def_error;

char
 *PAN_ATTRIBUTE = NULL,
 *PAN_DIMENSION = NULL,
 *PAN_DOMAIN = NULL,
 *PAN_EDIT_REQUEST = NULL,
 *PAN_EDIT_OUT = NULL,
 *PAN_UNIT = NULL;

char
 *PA_INFO_TYPE_S,
 *PA_INFO_N_DIMS_S,
 *PA_INFO_DIMS_S,
 *PA_INFO_SCOPE_S,
 *PA_INFO_CLASS_S,
 *PA_INFO_CENTER_S,
 *PA_INFO_PERSISTENCE_S,
 *PA_INFO_ALLOCATION_S,
 *PA_INFO_FILE_NAME_S,
 *PA_INFO_INIT_VAL_S,
 *PA_INFO_INIT_FNC_S,
 *PA_INFO_CONV_S,   /* ext_unit */
 *PA_INFO_UNIT_S,   /* int_unit */
 *PA_INFO_KEY_S,
 *PA_INFO_ATTRIBUTE_S,
 *PA_INFO_UNITS_S,
 *PA_INFO_DATA_PTR_S,
 *PA_INFO_UNIT_NUMER_S,
 *PA_INFO_UNIT_DENOM_S,
 *PA_INFO_APPL_ATTR_S,
 *PA_INFO_DEFAULT_S,
 *PA_INFO_SHARE_S,
 *PA_INFO_ATT_NAME_S,
 *PA_INFO_DIM_NAME_S,
 *PA_INFO_UNITS_NAME_S,
 *PA_INFO_DOMAIN_NAME_S,
 *PA_INFO_MAP_DOMAIN_S,
 *PA_INFO_BUILD_DOMAIN_S;

HASHTAB
 *PA_var_att_tab = NULL,
 *PA_var_def_tab = NULL,
 *PA_var_dim_tab = NULL,
 *PA_var_domain_tab = NULL,
 *PA_var_unit_tab = NULL;

PA_variable
 *_PA_default_variable = NULL;

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PA_DEF_VARIABLE - define a variable
 *                 - process the arguments then install into the
 *                 - variable table
 */

#ifdef ANSI

PA_variable *PA_def_variable(char *name, ...)

#endif

#ifdef PCC

PA_variable *PA_def_variable(name, va_alist)
    char *name;
    va_dcl

#endif

   {PA_variable *pp;

    SC_VA_START(name);
    pp = _PA_process_def_var(name, &SC_VA_VAR);
    SC_VA_END;
  
    if (PA_VARIABLE_ALLOCATION(pp) == STATIC)
       {PA_WARN((PA_VARIABLE_DATA(pp) == NULL),
		"VARIABLE %s IS STATIC AND PA_INFO_DATA_PTR IS NOT DEFINED",
		PA_VARIABLE_NAME(pp));};

    PA_variable_tab = PA_install_table(name, pp,
				       PAN_VARIABLE,
				       PA_variable_tab);

    return(pp);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PA_DEF_VAR_DEFAULT - define a variable default template
 *                    - it's just like a variable, except it's not in the
 *                    - variable table, it's in PA_va_def_tab
 *                    - maybe this this be changed someday to use
 *                    - package scoping instead of a different table
 */

#ifdef ANSI

PA_variable *PA_def_var_default(char *name, ...)

#endif

#ifdef PCC

PA_variable *PA_def_var_default(name, va_alist)
   char *name;
   va_dcl

#endif

   {PA_variable *pp;

    SC_VA_START(name);
    pp = _PA_process_def_var(name, &SC_VA_VAR);
    SC_VA_END;

    PA_var_def_tab = PA_install_table(name, pp,
				      PAN_VARIABLE,
				      PA_var_def_tab);

    return(pp);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PA_DEF_VAR_ATTRIBUTE - take a bunch of variable attributes, put them
 *                      - on an alist and store into a table
 *                      - it can be looked up later,
 *                      - by _PA_process_def_var and used to define
 *                      - attributes for variable
 */

#ifdef ANSI

pcons *PA_def_var_attribute(char *name, ...)

#endif

#ifdef PCC

pcons *PA_def_var_attribute(name, va_alist)
   char *name;
   va_dcl

#endif
   {int enough;
    int tag;
    pcons *att_alist = NULL;

    att_alist = NULL;

    SC_VA_START(name);

    enough = FALSE;
    while (!enough)
       {tag = SC_VA_ARG(int);
	switch (tag)
	   {case PA_INFO_ALLOCATION :
            case PA_INFO_CENTER :
            case PA_INFO_CLASS :
            case PA_INFO_PERSISTENCE :
            case PA_INFO_SCOPE :
                 att_alist = _PA_process_att(tag, &SC_VA_VAR, att_alist);
		 break;

            case LAST_TAG:
                 enough = TRUE;
		 break;

            default:
                 PA_def_error = 1;
	         PA_WARN(PA_def_error,
			 "ILLEGAL TAG IN PA_DEF_VAR_ATTRIBUTE %s (%d = %s)",
			 name, tag, PA_info_name(tag));};};

    SC_VA_END;

/* check if att_alist is null, no fields */

/* store in table */
    PA_var_att_tab = PA_install_table(name, att_alist,
				      PAN_ATTRIBUTE,
				      PA_var_att_tab);

    return(att_alist);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PA_DEF_VAR_DIMENSION - define variable dimensions */

#ifdef ANSI

PA_dimens *PA_def_var_dimension(char *name, ...)

#endif

#ifdef PCC

PA_dimens *PA_def_var_dimension(name, va_alist)
   char *name;
   va_dcl

#endif

   {PA_dimens *vdims;

    SC_VA_START(name);
    vdims = _PA_process_dimension(&SC_VA_VAR);
    SC_VA_END;

/* store in table */
    PA_var_dim_tab = PA_install_table(name, vdims,
				      PAN_DIMENSION,
				      PA_var_dim_tab);

    return(vdims);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PA_DEF_VAR_UNIT - define variable units */

#ifdef ANSI

pcons *PA_def_var_units(char *name, ...)

#endif

#ifdef PCC

pcons *PA_def_var_units(name, va_alist)
   char *name;
   va_dcl

#endif

   {pcons *unit_alist;

    unit_alist = NULL;
    SC_VA_START(name);
    unit_alist = _PA_process_units(&SC_VA_VAR, unit_alist);
    SC_VA_END;
    
/* store in table */
    PA_var_unit_tab = PA_install_table(name, unit_alist,
				       PAN_UNIT,
				       PA_var_unit_tab);

    return(unit_alist);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PA_DEF_VAR_DOMAIN - define a variable domain */

#ifdef ANSI

void PA_def_var_domain(char *name, ...)

#endif

#ifdef PCC

void PA_def_var_domain(name, va_alist)
   char *name;
   va_dcl

#endif

  {

/* PA_var_dom_tab = PA_install_table(name, pp, PAN_DOMAIN, PA_var_dom_tab); */

   return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PA_DEF_VAR_INIT - define a variable initializer */

void PA_def_var_init()
   {int vattr[N_ATTRIBUTES];
    double conv_fact, unit_fact;
    char *vtype;
    pcons *nu, *du, *alist;
    PA_dimens *vdims;
    byte *iv;
    DECLFPTR(byte, ifn, (byte *p, long sz, char *s));
    PA_variable *pp;
    
/* setup defaults */
    if (_PA_default_variable == NULL)
       {vattr[0]  = RUNTIME;
	vattr[1]  = OPTL;
	vattr[2]  = REL;
	vattr[3]  = U_CENT;
	vattr[4]  = DYNAMIC;
	vdims     = NULL;
	iv        = NULL;
	ifn       = NULL;
	vtype     = SC_DOUBLE_S;
	conv_fact = 1.0;
	unit_fact = 1.0;
	nu        = NULL;
	du        = NULL;
	alist     = NULL;

	pp = _PA_mk_variable("default-variable", vdims, iv, ifn,
			     vattr, vtype,
			     conv_fact, unit_fact, nu, du, alist);

	PA_var_def_tab = PA_install_table("default-variable", pp,
					  PAN_VARIABLE, PA_var_def_tab);

	_PA_default_variable = pp;};

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PA_PROCESS_DEF_VAR - two tag alists are maintained to correspond to
 *                     - the two levels of precedence
 *                     - as each tag is read off of the input, interpret
 *                     - it and add the fields that it represents onto the
 *                     - correct alist
 *                     - the level of precedence from low to high is:
 *                     -    alist2
 *                     -    alist1
 *                     - look up the name given in the correct table
 *                     - and add the values defined in the corresponding
 *                     - PA_def_var_xxx call onto alist2
 *                     - for all the rest add the value onto alist1
 *                     -
 *                     - after all input has been added onto an alist
 *                     - search the lists in inverse order of precedence
 *                     - this will find the highest precedence last
 */

PA_variable *_PA_process_def_var(vname, list)
   char *vname;
   va_list *list;
   {int i;
    int enough;
    int tag;
    int *pival;
    int vattr[N_ATTRIBUTES];
    char *attr_name[N_ATTRIBUTES];
    char *name;
    char *vtype;
    char *tag_name;
    pcons *nu, *du, *alist;
    PA_variable *pp;
    PA_dimens *vdims;
    byte *iv;
    byte *data_ptr;
    DECLFPTR(byte, ifn, (byte *p, long sz, char *s));
    pcons *alist1, *alist2;
    pcons *att_alist, *unit_alist;
  
    attr_name[0] = PA_INFO_SCOPE_S;
    attr_name[1] = PA_INFO_CLASS_S;
    attr_name[2] = PA_INFO_PERSISTENCE_S;
    attr_name[3] = PA_INFO_CENTER_S;
    attr_name[4] = PA_INFO_ALLOCATION_S;

    vattr[0]  = PA_VARIABLE_SCOPE(_PA_default_variable);
    vattr[1]  = PA_VARIABLE_CLASS(_PA_default_variable);
    vattr[2]  = PA_VARIABLE_PERSISTENCE(_PA_default_variable);
    vattr[3]  = PA_VARIABLE_CENTERING(_PA_default_variable);
    vattr[4]  = PA_VARIABLE_ALLOCATION(_PA_default_variable);
    vdims     = PA_VARIABLE_DIMS(_PA_default_variable);
    iv        = PA_VARIABLE_INIT_VAL(_PA_default_variable);
    ifn       = PA_VARIABLE_INIT_FUNC(_PA_default_variable);
    vtype     = PA_VARIABLE_TYPE_S(_PA_default_variable);
    nu        = PA_VARIABLE_UNIT_NUMER(_PA_default_variable);
    du        = PA_VARIABLE_UNIT_DENOM(_PA_default_variable);
    alist     = PA_VARIABLE_ATTR(_PA_default_variable);
    data_ptr  = NULL;

/* make two alists, one for each precedence level */
    alist1 = NULL;  /* fields   PA_INFO_SCOPE =        */
    alist2 = NULL;  /* named groups PA_INFO_ATT_NAME = */

    SC_VA_SAVE(list);

    enough = FALSE;
    while (!enough)
       {tag = SC_VA_ARG(int);
	tag_name = PA_info_name(tag);
	switch (tag)

/* reset defaults */
           {case PA_INFO_SHARE :
	    case PA_INFO_DEFAULT :
	         name = SC_VA_ARG(char *);
		 if (tag == PA_INFO_DEFAULT)
		    pp = (PA_variable *) SC_def_lookup(name,
						       PA_var_def_tab);
		 else
		    pp = PA_inquire_variable(name);

/* override defaults */
		 vattr[0]  = PA_VARIABLE_SCOPE(pp);
		 vattr[1]  = PA_VARIABLE_CLASS(pp);
		 vattr[2]  = PA_VARIABLE_PERSISTENCE(pp);
		 vattr[3]  = PA_VARIABLE_CENTERING(pp);
		 vattr[4]  = PA_VARIABLE_ALLOCATION(pp);
		 vdims     = PA_VARIABLE_DIMS(pp);
		 iv        = PA_VARIABLE_INIT_VAL(pp);
		 ifn       = PA_VARIABLE_INIT_FUNC(pp);
		 vtype     = PA_VARIABLE_TYPE_S(pp);
		 nu        = PA_VARIABLE_UNIT_NUMER(pp);
		 du        = PA_VARIABLE_UNIT_DENOM(pp);
		 alist     = PA_VARIABLE_ATTR(pp);
		 break;
		 
	   case PA_INFO_INIT_VAL :
	        alist1 = SC_add_alist(alist1,
				      tag_name,
				      SC_POINTER_S,
				      SC_VA_ARG(byte *));
		 break;

	    case PA_INFO_INIT_FNC :
	         alist1 = SC_add_alist(alist1,
				       tag_name,
				       SC_POINTER_S,
				       SC_VA_ARG(PFByte *));
		 break;

	    case PA_INFO_TYPE :
   	         alist1 = SC_add_alist(alist1,
				       tag_name,
				       SC_STRING_S,
				       SC_VA_ARG(char *));
		 break;

	    case PA_INFO_ALLOCATION :
	    case PA_INFO_CENTER :
	    case PA_INFO_CLASS :
	    case PA_INFO_PERSISTENCE :
	    case PA_INFO_SCOPE :
	         alist1 = _PA_process_att(tag, &SC_VA_VAR, alist1);
		 break;

	    case PA_INFO_DIMS :
	         vdims = _PA_process_dimension(&SC_VA_VAR);
		 alist1 = SC_add_alist(alist1,
				       tag_name,
				       PAN_DIMENSION,
				       vdims);
		 break;

	    case PA_INFO_UNITS:
		 alist1 = _PA_process_units(&SC_VA_VAR, alist1);
		 break;

	    case PA_INFO_DATA_PTR:
		 data_ptr = SC_VA_ARG(byte *);
		 break;
      
	    case PA_INFO_ATT_NAME :
	         name = SC_VA_ARG(char *);
		 att_alist = (pcons *) SC_def_lookup(name, PA_var_att_tab);
		 if (att_alist == NULL)
		    {PA_def_error = 1;
		     PA_WARN(PA_def_error,
			     "UNDEFINED ATTR - PA_PROCESS_DEF_VAR\n%s\t%s = %s",
			     vname, tag_name, name);}
		 else
		    alist2 = SC_append_alist(alist2, att_alist);

		 break;

	    case PA_INFO_DIM_NAME :
	         name = SC_VA_ARG(char *);
		 vdims = (PA_dimens *) SC_def_lookup(name, PA_var_dim_tab);
		 if (vdims == NULL)
		    {PA_def_error = 1;
		     PA_WARN(PA_def_error,
			     "UNDEFINED DIM - PA_PROCESS_DEF_VAR\n%s\t%s = %s",
			     vname, tag_name, name);}
		 else
		    alist2 = SC_add_alist(alist2,
					  PA_info_name(PA_INFO_DIMS),
					  PAN_DIMENSION,
					  vdims);
		 break;

	    case PA_INFO_DOMAIN_NAME :
	         if (att_alist == NULL)
		    {PA_def_error = 1;
		     PA_WARN(PA_def_error,
			     "UNDEFINED DOMAIN - PA_PROCESS_DEF_VAR\n%s\t%s = %s",
			     vname, tag_name, name);};
		 break;

	    case PA_INFO_UNITS_NAME:
		 name = SC_VA_ARG(char *);
		 unit_alist = (pcons *) SC_def_lookup(name, PA_var_unit_tab);
		 if (unit_alist == NULL)
		    {PA_def_error = 1;
		     PA_WARN(PA_def_error,
			     "UNDEFINED UNIT - PA_PROCESS_DEF_VAR\n%s\t%s = %s",
			     vname, tag_name, name);}
		 else
		    alist2 = SC_append_alist(alist2, unit_alist);
		 break;

	    case LAST_TAG :
	         enough = 1;
		 break;
      
	    default:
		 {PFPPcons fnc;

		  fnc = PA_GET_FUNCTION(PFPPcons, "user_defined_attribute");
		  if (fnc == NULL)
		     {PA_def_error = 1;
		      PA_WARN(PA_def_error,
			      "UNKNOWN TAG - PA_PROCESS_DEF_VAR\n%s (%d)",
			      vname, tag);

/* since we don't recognise this tag, we don't know what should follow it
 * so don't process anymore
 */
		      enough = 1;}

		  else
		     alist2 = (*fnc)(tag, &SC_VA_VAR, alist2);};

		 break;};};

    SC_VA_RESTORE(list);

/* alist2 is the lower precedence list - search it first */

/* now search thru the tags and find current values */
    for (i = 0; i < 5; i++)
        {pival = (int *) SC_assoc(alist2, attr_name[i]);
	 if (pival)
 	    vattr[i] = *pival;};

    SC_assoc_info_alt(alist2,
		      PA_INFO_DIMS_S,         &vdims,
		      PA_INFO_INIT_VAL_S,     &iv,
		      PA_INFO_INIT_FNC_S,     &ifn,
		      PA_INFO_TYPE_S,         &vtype,
		      PA_INFO_UNIT_NUMER_S,   &nu,
		      PA_INFO_UNIT_DENOM_S,   &du,
		      PA_INFO_APPL_ATTR_S,    &alist,
		      NULL);
    
/* alist1 is the higher precedence list - search it last */

    for (i = 0; i < 5; i++)
        {pival = (int *) SC_assoc(alist1, attr_name[i]);
	 if (pival)
	    vattr[i] = *pival;};

    SC_assoc_info_alt(alist1,
		      PA_INFO_DIMS_S,         &vdims,
		      PA_INFO_INIT_VAL_S,     &iv,
		      PA_INFO_INIT_FNC_S,     &ifn,
		      PA_INFO_TYPE_S,         &vtype,
		      PA_INFO_UNIT_NUMER_S,   &nu,
		      PA_INFO_UNIT_DENOM_S,   &du,
		      PA_INFO_APPL_ATTR_S,    &alist,
		      NULL);
    
    pp = _PA_mk_variable(vname, vdims, iv, ifn, vattr, vtype,
			 1.0, 1.0, nu, du, alist);
    
    PA_VARIABLE_DATA(pp) = data_ptr;
    
/* clean up all this mess */
    if (alist1)
       SC_free_alist(alist1, 3);

    if (alist2)
       SC_free_alist(alist2, 3);

    return(pp);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PA_PROCESS_ATT - process the attribute tag */

pcons *_PA_process_att(tag, list, alist)
    int tag;
    va_list *list;
    pcons *alist;
    {int ival, *pival;
     char *tag_name, *value_name, *group;

     switch (tag)
        {case PA_INFO_ALLOCATION:
	      group = PA_CPP_ALLOCATION;
	      break;

 	 case PA_INFO_CENTER:
	      group = PA_CPP_CENTER;
	      break;

         case PA_INFO_CLASS:
	      group = PA_CPP_CLASS;
	      break;

	 case PA_INFO_PERSISTENCE:
	      group = PA_CPP_PERSISTENCE;
	      break;

         case PA_INFO_SCOPE:
	      group = PA_CPP_SCOPE;
	      break;

	 default:
	      group = NULL;
	      break;};

    if (group != NULL)

/* pull off value */
       {SC_VA_SAVE(list);
	ival = SC_VA_ARG(int);
	SC_VA_RESTORE(list);

	tag_name   = PA_cpp_value_to_name(PA_CPP_INFO, tag);
	value_name = PA_cpp_value_to_name(group, ival);

	if (value_name != NULL)
	   {pival = FMAKE(int, "_PA_PROCESS_ATT:pival");
	    *pival = ival;
	    alist = SC_add_alist(alist,
				 tag_name,
				 SC_INTEGER_P_S,
				 pival);}
	else
	   {alist = NULL;
	    PA_def_error = 1;

	    PA_WARN(PA_def_error,
		    "ILLEGAL TAG PAIR IN _PA_PROCESS_ATT\n\t %s=%d",
		    tag_name, ival);};};

    return(alist);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PA_PROCESS_DIMENSION - process the dimension list */

PA_dimens *_PA_process_dimension(list)
   va_list *list;
   {int *mini, *maxi, meth;
    PA_dimens *vdims, *next, *prev;

    SC_VA_SAVE(list);

/* get the dimensions */
    vdims = NULL;
    while ((maxi = SC_VA_ARG(int *)) != LAST)
       {if (maxi == PA_DUL)
	  {mini = SC_VA_ARG(int *);
	   maxi = SC_VA_ARG(int *);
	   meth = *PA_DUL;}
	
       else if (maxi == PA_DON)
	  {mini = SC_VA_ARG(int *);
	   maxi = SC_VA_ARG(int *);
	   meth = *PA_DON;}
	
       else
	  {mini = &Zero_I;
	   meth = *PA_DON;};

	next = _PA_mk_dimens(mini, maxi, meth);
	if (vdims == NULL)
	   vdims = next;
	else
 	   prev->next = next;
	prev = next;};
    
    SC_VA_RESTORE(list);

    return(vdims);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PA_PROCESS_UNITS - from the variable argument list defined by list
 *                   - process arguments to build up the numerator and
 *                   - denominator of the units
 */

pcons *_PA_process_units(list, alist)
   va_list *list;
   pcons *alist;
   {int dm, *pv;
    pcons *nu, *du, *next, *prev;

    SC_VA_SAVE(list);

/* get the units */
    nu = NULL;
    while (TRUE)
       {dm = SC_VA_ARG(int);
        if ((dm == PER) || (dm == UNITS))
           break;
        pv  = FMAKE(int, "_PA_PROCESS_UNITS:pv");
        *pv = dm;
        next = SC_mk_pcons(SC_INTEGER_P_S, pv, SC_PCONS_P_S, NULL);
        if (nu == NULL)
           nu = next;
        else
           prev->cdr = (byte *) next;
        prev = next;};

    du = NULL;
    if (dm != UNITS)
       while ((dm = SC_VA_ARG(int)) != UNITS)
          {pv  = FMAKE(int, "_PA_PROCESS_UNITS:pv");
           *pv = dm;
	   next = SC_mk_pcons(SC_INTEGER_P_S, pv, SC_PCONS_P_S, NULL);
           if (du == NULL)
              du = next;
           else
              prev->cdr = (byte *) next;
           prev = next;};

    SC_VA_RESTORE(list);

    alist = SC_add_alist(alist,
			 PA_info_name(PA_INFO_UNIT_NUMER),
			 SC_PCONS_P_S,
			 nu);
    alist = SC_add_alist(alist,
			 PA_info_name(PA_INFO_UNIT_DENOM),
			 SC_PCONS_P_S,
			 du);
    return(alist);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PA_INSTALL_TABLE - allocate hash table if it is NULL
 *                  - return a pointer to the hash table
 */

HASHTAB *PA_install_table(s, vr, type, tab)
   char *s;
   byte *vr;
   char *type;
   HASHTAB *tab;
   {if (tab == NULL)
       tab = SC_make_hash_table(HSZLARGE, NODOC);

    SC_install(s, vr, type, tab);

    return(tab);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/



