/*
 * GSMLTS.C - test the poly segment drawing capability in PGS
 *
 * Source Version: 2.0
 * Software Release #92-0043
 *
 */

#include "cpyright.h"

#include "pgs.h"

#define N_POINTS 10

#ifndef MAC
#define FAST
#endif

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

main(argc, argv)
   int argc;
   char **argv;
   {int i, k, l, m;
    int X_max, Y_max, Z_max;
    long n_seg, n_pts;
    double x, y, z, dx, dy, dz, theta, phi;
    char *s, t[MAXLINE], *token, *pt;
    PG_device *SCR_dev, *SCR_dew, *PS_dev, *CGM_dev;
    REAL *rx, *ry, *rz, *px, *py, *pz;

    if (argc > 1)
       X_max = Y_max = Z_max = atoi(argv[1]);
    else
       {X_max  = N_POINTS;
        Y_max  = N_POINTS;
        Z_max  = N_POINTS;};

    n_seg = (X_max - 1)*Y_max*Z_max + X_max*(Y_max - 1)*Z_max +
            X_max*Y_max*(Z_max - 1);
    n_pts = 2*n_seg;

    PG_open_console("GSMLTS", "MONOCHROME", 1,
                    0.55, 0.1, 0.4, 0.8);

    SCR_dev = PG_make_device("WINDOW", "MONOCHROME", "PGS Poly Segment 2D Test");
    PG_open_device(SCR_dev, 0.09, 0.1, 0.4, 0.4);

    SCR_dew = PG_make_device("WINDOW", "MONOCHROME", "PGS Poly Segment 3D Test");
    PG_open_device(SCR_dew, 0.51, 0.1, 0.4, 0.4);

#ifdef FAST

    PS_dev = PG_make_device("PS", "MONOCHROME", "gsmlts");
    PG_open_device(PS_dev, 0.0, 0.0, 0.0, 0.0);

    CGM_dev = PG_make_device("CGM", "MONOCHROME", "gsmlts");
    PG_open_device(CGM_dev, 0.0, 0.0, 0.0, 0.0);

#endif

    rx = px = FMAKE_N(REAL, n_pts, "GSMLTS.C:rx");
    ry = py = FMAKE_N(REAL, n_pts, "GSMLTS.C:ry");
    rz = pz = FMAKE_N(REAL, n_pts, "GSMLTS.C:rz");

/* compute a lattice */
    dx = 1.0/((double) X_max);
    dy = 2.0/((double) Y_max);
    dz = 3.0/((double) Y_max);
    for (k = 0; k < X_max; k++)
        {x = ((double) k)*dx;
         for (l = 0; l < Y_max; l++)
             {y = ((double) l)*dy;
              for (m = 0; m < Z_max - 1; m++)
                  {z     = ((double) m)*dz;
                   *px++ = x;
                   *py++ = y;
                   *pz++ = z;

                   *px++ = x;
                   *py++ = y;
                   *pz++ = z + dz;};};};

    for (m = 0; m < Z_max; m++)
        {z = ((double) m)*dz;
         for (k = 0; k < X_max; k++)
             {x = ((double) k)*dx;
              for (l = 0; l < Y_max - 1; l++)
                  {y     = ((double) l)*dy;
                   *px++ = x;
                   *py++ = y;
                   *pz++ = z;

                   *px++ = x;
                   *py++ = y + dy;
                   *pz++ = z;};};};

    for (l = 0; l < Y_max; l++)
        {y = ((double) l)*dy;
         for (m = 0; m < Z_max; m++)
             {z = ((double) m)*dz;
              for (k = 0; k < X_max - 1; k++)
                  {x     = ((double) k)*dx;
                   *px++ = x;
                   *py++ = y;
                   *pz++ = z;

                   *px++ = x + dx;
                   *py++ = y;
                   *pz++ = z;};};};

/* draw a cubic lattice */
    PG_set_clipping(SCR_dev, TRUE);
    PG_set_clipping(SCR_dew, TRUE);
    PG_set_clipping(PS_dev, TRUE);
    PG_set_clipping(CGM_dev, TRUE);

    PG_turn_autorange(SCR_dev, TRUE);
    PG_turn_autorange(SCR_dew, TRUE);
    PG_turn_autorange(PS_dev, TRUE);
    PG_turn_autorange(CGM_dev, TRUE);

    for (i = 1; TRUE; i++)
       {PRINT(STDOUT, "Viewing Angle: ");
        GETLN(t, MAXLINE, stdin);

        if ((token = SC_strtok(t, " ,", pt)) == NULL)
           break;
        theta = DEG_RAD*ATOF(token);

        if ((token = SC_strtok(NULL, " ,", pt)) == NULL)
           break;
        phi = DEG_RAD*ATOF(token);

        PG_set_color_line(SCR_dev, i, TRUE);
        PG_set_color_line(SCR_dew, i, TRUE);
        PG_set_color_line(PS_dev, i, TRUE);
        PG_set_color_line(CGM_dev, i, TRUE);

        PG_clear_window(SCR_dev);
        PG_clear_window(PS_dev);
        PG_clear_window(CGM_dev);

        PG_draw_disjoint_polyline_2(SCR_dev, rx, ry, n_seg, TRUE, TRUE);
        PG_draw_disjoint_polyline_2(PS_dev, rx, ry, n_seg, TRUE, TRUE);
        PG_draw_disjoint_polyline_2(CGM_dev, rx, ry, n_seg, TRUE, TRUE);

        PG_finish_plot(SCR_dew);
        PG_finish_plot(PS_dev);
        PG_finish_plot(CGM_dev);

        PG_clear_window(SCR_dew);
        PG_clear_window(PS_dev);
        PG_clear_window(CGM_dev);

        PG_draw_disjoint_polyline_3(SCR_dew, rx, ry, rz,
                                    theta, phi, n_seg, TRUE);
        PG_draw_disjoint_polyline_3(PS_dev, rx, ry, rz,
                                    theta, phi, n_seg, TRUE);
        PG_draw_disjoint_polyline_3(CGM_dev, rx, ry, rz,
                                    theta, phi, n_seg, TRUE);

        PG_finish_plot(SCR_dew);
        PG_finish_plot(PS_dev);
        PG_finish_plot(CGM_dev);};

    PG_close_device(SCR_dev);
    PG_close_device(SCR_dew);

#ifdef FAST

    PG_close_device(PS_dev);
    PG_close_device(CGM_dev);

#endif

    exit(0);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
