/*
 * GSPR_X.C - PGS X primitive routines
 *
 * Source Version: 2.0
 * Software Release #92-0043
 *
 */

#include "cpyright.h"
 
#include "pgs.h"

extern SC_dynamic_array
 _PG_X_point_list;

/*--------------------------------------------------------------------------*/

/*                         STATE QUERY ROUTINES                             */

/*--------------------------------------------------------------------------*/

/* _PG_X_GET_TEXT_EXT_NDC - return the text extent in NDC
 *                        - of the given string
 */

void _PG_X_get_text_ext_NDC(dev, s, px, py)
   PG_device *dev;
   char *s;
   REAL *px, *py;
   {REAL tx, ty;
    int ix, iy, len, dir, asc, dsc;
    XCharStruct overall;
    XFontStruct *fnt;
    Display *disp;

    disp = dev->display;
    if (disp == NULL)
       return;

    len = strlen(s);
    fnt = dev->font_info;
    XTextExtents(fnt, s, len, &dir, &asc, &dsc, &overall);
    
    ix = overall.width;
    iy = asc + dsc;

    tx = ix/dev->window_width;
    ty = iy/dev->window_height;

    *px = tx;
    *py = ty;

    return;}

/*--------------------------------------------------------------------------*/

/*                          STATE CHANGE ROUTINES                           */

/*--------------------------------------------------------------------------*/
 
/* _PG_X_SET_LOGICAL_OP - set the logical operation */
 
void _PG_X_set_logical_op(dev, lop)
   PG_device *dev;
   int lop;
   {Display *disp;
    GC xgc;

    dev->logical_op = lop;

    disp = dev->display;
    if (disp == NULL)
       return;

    xgc = dev->gc;

    switch (lop)
       {case GS_XOR :
             XSetFunction(disp, xgc, GXxor);
             break;

        default      :
	case GS_COPY :
	     XSetFunction(disp, xgc, GXcopy);
             break;};

    return;}
 
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
 
/* _PG_X_SET_LINE_STYLE - set the line style */
 
void _PG_X_set_line_style(dev, style)
   PG_device *dev;
   int style;
   {int ls, n;
    char dl[32];
    Display *disp;
    GC xgc;

    dev->line_style = style;

    disp = dev->display;
    if (disp == NULL)
       return;

    xgc   = dev->gc;
    switch (style)
       {case LINE_DASHED    :
             ls = LineOnOffDash;
             n  = 2;
             dl[0] = 7;
             dl[1] = 3;
             XSetDashes(disp, xgc, 0, dl, n);
             break;

        case LINE_DOTTED    :
             ls = LineOnOffDash;
             n  = 2;
             dl[0] = 3;
             dl[1] = 3;
             XSetDashes(disp, xgc, 0, dl, n);
             break;

        case LINE_DOTDASHED :
             ls = LineOnOffDash;
             n  = 4;
             dl[0] = 7;
             dl[1] = 3;
             dl[2] = 3;
             dl[3] = 3;
             XSetDashes(disp, xgc, 0, dl, n);
             break;

       case LINE_SOLID     :
       default             :
             ls = LineSolid;
             break;};

    dev->X_line_style = ls;
    XSetLineAttributes(disp, xgc, dev->X_line_width, 
                       ls, dev->X_cap_style,
                       dev->X_join_style);
 
    return;}
 
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
 
/* _PG_X_SET_LINE_WIDTH - set the line width */
 
void _PG_X_set_line_width(dev, width)
   PG_device *dev;
   double width;
   {unsigned int lwd;
    Display *disp;

    dev->line_width = width;

    disp = dev->display;
    if (disp == NULL)
       return;
 
    lwd               = 3.0*max(width, 0.0);
    dev->X_line_width = lwd;
    XSetLineAttributes(disp, dev->gc, lwd,
                       dev->X_line_style,
                       dev->X_cap_style,
                       dev->X_join_style);
 
    return;}
 
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
 
/* _PG_X_SET_LINE_COLOR - set the line color */
 
void _PG_X_set_line_color(dev, color, mapped)
   PG_device *dev;
   int color, mapped;
   {Display *disp;

    dev->line_color = color;

    disp = dev->display;
    if (disp == NULL)
       return;
 
    if (mapped)
       color = _PG_trans_color(dev, color);

    XSetForeground(disp, dev->gc,
                   dev->current_palette->pixel_value[color]);
 
    return;}
 
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
 
/* _PG_X_SET_TEXT_COLOR - set the color of the text */
 
void _PG_X_set_text_color(dev, color, mapped)
   PG_device *dev;
   int color, mapped;
   {unsigned short *pi;
    Display *disp;

    dev->text_color = color;

    disp = dev->display;
    if (disp == NULL)
       return;
 
    if (mapped)
       color = _PG_trans_color(dev, color);

    pi = dev->current_palette->pixel_value;
    XSetForeground(disp, dev->gc, pi[color]);
 
    return;}
 
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PG_X_SET_FILL_COLOR - sets current fill color */

void _PG_X_set_fill_color(dev, color, mapped)
   PG_device *dev;
   int color, mapped;
   {Display *disp;

    dev->fill_color = color;

    disp = dev->display;
    if (disp == NULL)
       return;
 
    if (mapped)
       XSetForeground(disp, dev->gc,
                      dev->current_palette->pixel_value[color]);
    else
       XSetForeground(disp, dev->gc, color);

    return;}
 
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PG_X_SET_CHAR_SIZE_NDC - set the character size in NCD */

void _PG_X_set_char_size_NDC(dev, x, y)
   PG_device *dev;
   double x, y;
   {dev->char_height_s = (REAL) y;
    dev->char_width_s  = (REAL) x;

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PG_X_SET_CHAR_PATH - set the direction along which text will be written
 *                     - defaults to (1, 0)
 */

void _PG_X_set_char_path(dev, x, y)
   PG_device *dev;
   double x, y;
   {dev->char_path_x = x;
    dev->char_path_y = y;

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PG_X_SET_CHAR_PRECISION - set the character precision
 *                          - fast and fixed size or
 *                          - slow and flexible
 */

void _PG_X_set_char_precision(dev, p)
   PG_device *dev;
   int p;
   {dev->char_precision = p;

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PG_X_SET_CHAR_SPACE - set the space between characters */

void _PG_X_set_char_space(dev, s)
   PG_device *dev;
   double s;
   {dev->char_space = (REAL) s;

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PG_X_SET_CHAR_UP - set the direction which is up for individual
 *                   - characters
 *                   - defaults to (0, 1)
 */

void _PG_X_set_char_up(dev, x, y)
   PG_device *dev;
   double x, y;
   {dev->char_up_x = (REAL) x;
    dev->char_up_y = (REAL) y;

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
 
/* _PG_X_SET_CHAR_LINE - set the number characters per line */
 
void _PG_X_set_char_line(dev, n)
   PG_device *dev;
   int n;
   {return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
 
/* _PG_X_SET_CLIPPING - set clipping
 *                    - flag = FALSE  -->  clipping off
 *                    - flag = TRUE   -->  clipping on
 */

void _PG_X_set_clipping(dev, flag)
   PG_device *dev;
   int flag;
   {int ix0, iy0, ix1, iy1;
    int iw, ih;
    REAL xmin, xmax, ymin, ymax;
    XRectangle cliprect[1];
    Display *disp;

    disp = dev->display;
    if (disp == NULL)
       return;

    PG_get_viewport_WC(dev, &xmin, &xmax, &ymin, &ymax);

    _PG_find_clip_region(dev, xmin, xmax, ymin, ymax,
                         &ix0, &iy0, &ix1, &iy1, flag, FALSE);

    iw = ix1 - ix0 + 1;
    ih = iy1 - iy0 + 1;
      
    cliprect[0].x = 0;
    cliprect[0].y = 0;
    cliprect[0].width = iw;
    cliprect[0].height = ih;
 
    XSetClipRectangles(disp, dev->gc, ix0, iy0,
                       cliprect, 1, Unsorted);
 
    dev->clipping = flag;

    return;}
 
/*--------------------------------------------------------------------------*/

/*                          MOVE AND DRAW ROUTINES                          */

/*--------------------------------------------------------------------------*/
 
/* _PG_X_MOVE_GR_ABS - move the current graphics cursor position to the
 *                   - given absolute coordinates in WC
 */
 
void _PG_X_move_gr_abs(dev, x, y)
   PG_device *dev;
   double x, y;
   {
 
/* if log axis options have been used take logs */
    if (dev->ifxlog)
       x = log10(ABS(x) + SMALL);
    if (dev->ifylog)
       y = log10(ABS(y) + SMALL);
 
    dev->gcurx = x;
    dev->gcury = y;

    return;}
 
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
 
/* _PG_X_MOVE_TX_ABS - move the current text cursor position to the
 *                   - given coordinates in WC
 */
 
void _PG_X_move_tx_abs(dev, x, y)
   PG_device *dev;
   double x, y;
   {
 
/* if log axis options have been used take logs */
    if (dev->ifxlog)
       x = log10(ABS(x) + SMALL);
    if (dev->ifylog)
       y = log10(ABS(y) + SMALL);
 
    dev->tcurx = x;
    dev->tcury = y;

    return;}
 
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
 
/* _PG_X_MOVE_TX_REL - move the current text cursor position to the
 *                   - given relative coordinates in WC
 */
 
void _PG_X_move_tx_rel(dev, x, y)
   PG_device *dev;
   double x, y;
   {

/* if log axis options have been used take logs */
    if (dev->ifxlog)
       x = log10(ABS(x) + SMALL);
    if (dev->ifylog)
       y = log10(ABS(y) + SMALL);
 
    dev->tcurx += x;
    dev->tcury += y;
 
    return;}
 
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
 
/* _PG_X_DRAW_TO_ABS - draw a line from current position to
 *                   - absolute position (x, y)
 *                   - in WC
 */
 
void _PG_X_draw_to_abs(dev, x, y)
   PG_device *dev;
   double x, y;
   {int ix1, iy1, ix2, iy2;
    REAL x1, y1;
    Display *disp;

    disp = dev->display;
    if (disp == NULL)
       return;
 
/* if log axis options are on, take logs */
    if (dev->ifxlog)
       x = log10(ABS(x) + SMALL);
    if (dev->ifylog)
       y = log10(ABS(y) + SMALL);

    x1 = dev->gcurx;
    y1 = dev->gcury;

    dev->gcurx = x;
    dev->gcury = y;

    WtoS(dev, x1, y1);
    WtoS(dev, x, y);
    StoP(dev, x1, y1, ix1, iy1);
    StoP(dev, x, y, ix2, iy2);
 
    XDrawLine(disp, dev->window, dev->gc, ix1, iy1, ix2, iy2);
 
    return;}
 
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
 
/* _PG_X_DRAW_TO_REL - draw a line from current position to
 *                   - relative position (x, y)
 *                   - in WC
 */
 
void _PG_X_draw_to_rel(dev, x, y)
   PG_device *dev;
   double x, y;
   {REAL x1, y1, x2, y2;
    int ix1, iy1, ix2, iy2;
    Display *disp;

    disp = dev->display;
    if (disp == NULL)
       return;

/* if log axis options are on, take logs */
    if (dev->ifxlog)
       x = log10(ABS(x) + SMALL);
    if (dev->ifylog)
       y = log10(ABS(y) + SMALL);
 
    x1 = dev->gcurx;
    y1 = dev->gcury;
    x2 = dev->gcurx + x;
    y2 = dev->gcury + y;

    dev->gcurx = x2;
    dev->gcury = y2;

    WtoS(dev, x1, y1);
    WtoS(dev, x2, y2);
    StoP(dev, x1, y1, ix1, iy1);
    StoP(dev, x2, y2, ix2, iy2);
 
    XDrawLine(disp, dev->window, dev->gc, ix1, iy1, ix2, iy2);
 
    return;}
 
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
 
/* _PG_X_DRAW_CURVE - plot the points from a PG_curve */
 
void _PG_X_draw_curve(dev, crv, clip)
   PG_device *dev;
   PG_curve *crv;
   int clip;
   {int i, n, j, xo, yo, nmax;
    int *px, *py;
    XPoint *pts;
    Display *disp;
    Window wind;
    GC gc;

    disp = dev->display;
    if (disp == NULL)
       return;

    wind = dev->window;
    gc   = dev->gc;

    n  = crv->n;
    px = crv->x;
    py = crv->y;
    xo = crv->x_origin;
    yo = crv->y_origin;
    
    nmax = (XMaxRequestSize(disp) - 3L) >> 1L;
    pts  = FMAKE_N(XPoint, nmax, "_PG_X_DRAW_CURVE:pts");
    for (i = 0; i < n; i += nmax)
      {if (i+nmax > n)
          nmax = n - i;

       for (j = 0; j < nmax; j++)
           {pts[j].x = *px++ + xo;
            pts[j].y = *py++ + yo;};

       XDrawLines(disp, wind, gc, pts, nmax, CoordModeOrigin);};
    
    SFREE(pts);

    return;}
 
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PG_X_DRAW_DISJOINT_POLYLINE_2 - draws disjoint two dimensional
 *                                - line segments specified in WC
 */

void _PG_X_draw_disjoint_polyline_2(dev, x, y, n, flag, coord)
   PG_device *dev;
   REAL *x, *y;
   long n;
   int flag, coord;
   {REAL *px, *py;
    int i, j, k, nmax;
    short ix1, iy1, ix2, iy2;
    REAL x1, y1, x2, y2;
    XSegment *segs;
    Display *disp;
    Window wind;
    GC gc;

    disp = dev->display;
    if ((disp == NULL) || (n == 0))
       return;

/* if auto ranging or domaining is on the data will control the WC system */
    if (flag && (dev->autorange || dev->autodomain))
       PG_set_limits(dev, x, y, 2*n, CARTESIAN);

    px = x;
    py = y;

    PG_move_gr_abs(dev, x[0], y[0]);

    wind = dev->window;
    gc   = dev->gc;
    
    nmax = (XMaxRequestSize(disp) - 3L) >> 1L;
    segs = FMAKE_N(XSegment, nmax,
                   "_PG_X_DRAW_DISJOINT_POLYLINE_2:segs");
    for (i = 0; i < n; i += nmax)
        {if (i+nmax > n)
            nmax = n - i;
       
         memset(segs, 0, nmax*sizeof(XSegment));
         for (k = 0, j = 0; j < nmax; j++)
             {x1 = *px++;
              y1 = *py++;
              x2 = *px++;
              y2 = *py++;

              if (coord)
                 {if (dev->ifxlog)
                     {x1 = log10(ABS(x1) + SMALL);
                      x2 = log10(ABS(x2) + SMALL);};
                  if (dev->ifylog)
                     {y1 = log10(ABS(y1) + SMALL);
                      y2 = log10(ABS(y2) + SMALL);};

                  WtoS(dev, x1, y1);
                  WtoS(dev, x2, y2);};

	      StoP(dev, x1, y1, ix1, iy1);
	      StoP(dev, x2, y2, ix2, iy2);

	      if ((ix1 != ix2) || (iy1 != iy2))
		 {segs[k].x1 = ix1;
		  segs[k].y1 = iy1;
		  segs[k].x2 = ix2;
		  segs[k].y2 = iy2;
		  k++;};};
       
         XDrawSegments(disp, wind, gc, segs, k);
         XFlush(disp);};
    
    SFREE(segs);

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
 
/* _PG_X_SHADE_POLY - polygon shading routine */

void _PG_X_shade_poly(dev, x, y, n)
   PG_device *dev;
   REAL *x, *y;
   int n;
   {int i, ix, iy;
    REAL xl, yl;
    XPoint p, *points;
    Display *disp;

    disp = dev->display;
    if (disp == NULL)
       return;

/* assume the points are given in counter-clockwise order */
    for (i = 0; i < n; i++)
        {xl = x[i];
         yl = y[i];
       
         WtoS(dev, xl, yl);
         StoP(dev, xl, yl, ix, iy);

	 p.x = ix;
	 p.y = iy;
	 SC_REMEMBER_DYNAMIC(XPoint, p, _PG_X_point_list);};

    points = SC_ARRAY_DYNAMIC(XPoint, _PG_X_point_list);
    SC_N_DYNAMIC(_PG_X_point_list) = 0;

    XFillPolygon(disp, dev->window, dev->gc, points, n,
                 Nonconvex, CoordModeOrigin);

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
 
/* _PG_X_FILL_CURVE - fill closed curves */

void _PG_X_fill_curve(dev, crv)
   PG_device *dev;
   PG_curve *crv;
   {int i, n, xo, yo;
    int *x, *y;
    XPoint p, *points;
    Display *disp;

    disp = dev->display;
    if (disp == NULL)
       return;

    n  = crv->n;
    x  = crv->x;
    y  = crv->y;
    xo = crv->x_origin;
    yo = crv->y_origin;
    
/* assume the points are given in counter-clockwise order */
    for (i = 0; i < n; i++)
        {p.x = x[i] + xo;
	 p.y = y[i] + yo;
	 SC_REMEMBER_DYNAMIC(XPoint, p, _PG_X_point_list);};

    points = SC_ARRAY_DYNAMIC(XPoint, _PG_X_point_list);
    SC_N_DYNAMIC(_PG_X_point_list) = 0;

    XFillPolygon(disp, dev->window, dev->gc, points, n,
                 Nonconvex, CoordModeOrigin);

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PG_X_PUT_IMAGE - put the image on the screen
 *                 - the image buffer may be overwritten by the pseudo color
 *                 - mapping if it is needed!!
 */

void _PG_X_put_image(dev, bf, ix, iy, nx, ny)
   PG_device *dev;
   unsigned char *bf;
   int ix, iy, nx, ny;
   {int i, k, l, n;
    unsigned short *pixel_value;
    XImage *xim;
    Display *disp;
    REAL rv;
    int n_pal_colors, n_dev_colors;
    PG_palette *pal;
    RGB_color_map *pseudo_cm;

    disp = dev->display;
    if (disp == NULL)
       return;

    pal          = dev->current_palette;
    n_dev_colors = dev->absolute_n_color;
    n_pal_colors = pal->n_pal_colors;
    pseudo_cm    = pal->pseudo_colormap;

    if ((n_dev_colors < n_pal_colors) && (pseudo_cm != NULL))
       {unsigned char *pbf;

        pbf = bf;
        PM_random(-1);
        for (l = 0; l < ny; l++)
            for (k = 0; k < nx; k++)
                {i      = *pbf;
                 rv     = 3.5*PM_random(1) - 0.83;
                 *pbf++ = (rv < pseudo_cm[i].red) ?
                          pseudo_cm[i].green : pseudo_cm[i].blue;};};

/* compress a zpixmap to a zbitmap for black and white systems - X bug */
    if (n_dev_colors < 3)
       {_PG_byte_bit_map(bf, nx, ny, FALSE);

        xim = XCreateImage(disp, DefaultVisual(disp, XDefaultScreen(disp)),
			   DisplayPlanes(disp, XDefaultScreen(disp)),
			   XYPixmap, 0,
			   (char *) bf,
			   (unsigned int) nx, (unsigned int) ny,
			   8, 0);}
    else
       {PG_invert_image_data(bf, nx, ny, 1);
	xim = XCreateImage(disp, DefaultVisual(disp, XDefaultScreen(disp)),
			   DisplayPlanes(disp, XDefaultScreen(disp)),
			   ZPixmap, 0,
			   (char *) bf,
			   (unsigned int) nx, (unsigned int) ny,
			   8, 0);

/* map the pixel values to the colors */
        n = nx*ny;
        pixel_value = pal->pixel_value;
        for (i = 0; i < n; i++)
            bf[i] = pixel_value[bf[i]];};

    XPutImage(disp, dev->window, dev->gc, xim, 0, 0, ix, iy, nx, ny);
    XFlush(disp);
    xim->data = NULL;
    XDestroyImage(xim);

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PG_X_GET_IMAGE - get the image on the screen into
 *                 - the image buffer
 */

void _PG_X_get_image(dev, bf, ix, iy, nx, ny)
   PG_device *dev;
   unsigned char *bf;
   int ix, iy, nx, ny;
   {return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

