/*
 * GSRSTT.C - test of PGS raster device
 *
 * Source Version: 2.0
 * Software Release #92-0043
 *
 */

#include "cpyright.h"

#include "pgs.h"

#define N 50

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

main(argc, argv)
   int argc;
   char *argv[];
   {int i, k, l, X_max, Y_max, image_test, color, ids;
    char *s;
    unsigned char *bf;
    double dx, dy, xv, yv, sf;
    REAL *x, *y;
    PG_graph *data;
    PG_palette *pl;
    PG_image *calc_im;
    PG_device *PS_dev;

    s = SC_strsavef("WINDOW", "char*:GSRSTT:s");
    image_test = TRUE;
    color = FALSE;
    ids = FALSE;

    for (i = 1; i < argc; i++)
        if (argv[i][0] == '-')
           {switch (argv[i][1])
               {case 'h' : i++;
                           s = argv[i];
                           break;
                case 'c' : color = TRUE;
                           break;
                case 'd' : ids = TRUE;
                           break;
                case 's' : image_test = FALSE;
                           break;};};

    x = FMAKE_N(REAL, N, "GSRSTT.C:x");
    y = FMAKE_N(REAL, N, "GSRSTT.C:y");

    for (i = 0; i < N; i++)
        {x[i] = -(i+1)/10.0;
         y[i] = 6.022e23/x[i];};

    data = PG_make_graph_1d('A', "Test Data #1", FALSE, N,
                            x, y, "X Values", "Y Values");

    if (color)
       PS_dev = PG_make_device("RASTER", "COLOR", "gspsts");
    else
       PS_dev = PG_make_device("RASTER", "MONOCHROME", "gspsts");

/* set up the hard copy device */
    PG_turn_data_id(PS_dev, ids);

    PG_open_device(PS_dev, 0.0, 0.0, 0.0, 0.0);

    data->info = PG_set_line_info(data->info, CARTESIAN, CARTESIAN,
				  SOLID, FALSE, 0, PS_dev->BLUE,
				  0, 0.0);
    PG_draw_graph(PS_dev, data);

    data->info = PG_set_line_info(data->info, POLAR, POLAR,
				  SOLID, FALSE, 0, PS_dev->GREEN,
				  0, 0.0);
    PG_draw_graph(PS_dev, data);

    data->info = PG_set_line_info(data->info, INSEL, INSEL,
				  SOLID, FALSE, 0, PS_dev->RED,
				  0, 0.0);
    PG_draw_graph(PS_dev, data);

    data->info = PG_set_line_info(data->info, HISTOGRAM, CARTESIAN,
				  SOLID, FALSE, 0, PS_dev->WHITE,
				  0, 0.0);
    PG_draw_graph(PS_dev, data);

    for (i = 0; i < N; i++)
        {x[i] = i/10.0;
         y[i] = cos(x[i]);};

    data = PG_make_graph_1d('B', "Test Data #2", FALSE, N,
                            x, y, "X Values", "Y Values");

    PG_turn_grid(PS_dev, ON);

    data->info = PG_set_line_info(data->info, HISTOGRAM, CARTESIAN,
				  SOLID, FALSE, 0, PS_dev->MAGENTA,
				  1, 0.0);
    PG_draw_graph(PS_dev, data);

    data->info = PG_set_line_info(data->info, POLAR, POLAR,
				  SOLID, FALSE, 0, PS_dev->CYAN,
				  0, 0.0);
    PG_draw_graph(PS_dev, data);

    data->info = PG_set_line_info(data->info, INSEL, INSEL,
				  SOLID, FALSE, 0, PS_dev->YELLOW,
				  0, 0.0);
    PG_draw_graph(PS_dev, data);

    data->info = PG_set_line_info(data->info, CARTESIAN, CARTESIAN,
				  SOLID, FALSE, 0, PS_dev->DARK_GRAY,
				  0, 0.0);
    PG_draw_graph(PS_dev, data);

    if (image_test)
       {X_max  = 250;
        Y_max  = 250;

        calc_im = PG_make_image("Test Image", SC_CHAR_S, NULL,
                                0.0, 0.0, 0.0, 0.0, -1.0, 1.0,
                                X_max, Y_max, 4, NULL);
        if (calc_im == NULL)
           {PRINT(STDOUT, "CAN'T ALLOCATE IMAGE");
            exit(1);};

/* draw the first image */
        pl = PG_set_palette(PS_dev, "rainbow");
        bf = calc_im->buffer;
        sf = pl->n_pal_colors;
        for (l = 0; l < Y_max; l++)
            {for (k = 0; k < X_max; k++)
                 *bf++ = sf*((double) k)*((double) (Y_max - l - 1))/
                               ((double) Y_max*X_max);};

        PS_dev->grid  = OFF;

        PG_draw_image(PS_dev, calc_im, "Test Data A", NULL);

/* draw the second image */
        pl = PG_set_palette(PS_dev, "spectrum");
        dx = 2.0*PI/((double) X_max);
        dy = 2.0*PI/((double) Y_max);
        bf = calc_im->buffer;
        sf = pl->n_pal_colors;
        for (l = 0; l < Y_max; l++)
            {for (k = 0; k < X_max; k++)
                 {xv = ((double) k)*dx;
                  yv = ((double) (Y_max - l - 1))*dy;

                 *bf++ = sf*(0.5 + 0.5*sin(xv)*cos(yv));};};

        PG_draw_image(PS_dev, calc_im, "Test Data B", NULL);

        PG_rl_image(calc_im);};

    PG_close_device(PS_dev);

    exit(0);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
