/*
 * SCATST.C - test hashing and alist functionality
 *          - they share the following functionality
 *          -    install (SC_install, SC_change_alist)
 *          -    lookup  (SC_lookup, SC_def_lookup, SC_assoc, SC_assoc_entry)
 *          -    remove  (SC_hash_rem, SC_rem_alist)
 *
 * Source Version: 2.0
 * Software Release #92-0043
 *
 */

#include "score.h"

static int
 SC_DECLARE(run_test, (int n, PFInt tst)),
 SC_DECLARE(test_1, (void)),
 SC_DECLARE(test_2, (void)),
 SC_DECLARE(test_3, (void));

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
 
/* MAIN - start here */

main(argc, argv)
   int argc;
   char **argv;
   {int err;

    PRINT(STDOUT, "\n\t\t\tTest\tLeaked Memory\tTime\n");

    err = 0;

    err += run_test(1, test_1);
    err += run_test(2, test_2);
    err += run_test(3, test_3);

    PRINT(STDOUT, "\n");

    return(err);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
 
/* RUN_TEST - run a test and report the time and space taken */

static int run_test(n, tst)
   int n;
   PFInt tst;
   {int ret;
    double time;
    long da, db;

    time = SC_wall_clock_time();
    SC_mem_stats(NULL, NULL, &db, NULL);

    ret  = (*tst)();

    time  = SC_wall_clock_time() - time;
    SC_mem_stats(NULL, NULL, &da, NULL);

    PRINT(STDOUT, "\t\t\t%2d\t%8ld\t%.2f\n", n, da - db, time);

    return(ret);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
 
/* TEST_1 - test shared functionality
 *        -   install
 *        -   lookup
 *        -   def-lookup
 *        -   remove
 */

static int test_1()
   {int err;
    char *sa, *sb;
    char *ta, *tb;
    HASHTAB *tab;
    hashel *hpa, *hpb;
    pcons *lsa, *lsb;

/* hash table */
    sa = SC_strsavef("string-a", "char*:TEST_1:sa");
    sb = SC_strsavef("string-b", "char*:TEST_1:sb");

    err = 0;

    tab = SC_make_hash_table(HSZSMALL, NODOC);
    hpa = SC_install("a", sa, SC_STRING_S, tab);
    hpb = SC_install("b", sb, SC_STRING_S, tab);

    err += (hpa == NULL);
    err += (hpb == NULL);

    err += (hpa != SC_lookup("a", tab));
    err += (hpb != SC_lookup("b", tab));
    
    ta = (char *) SC_def_lookup("a", tab);
    tb = (char *) SC_def_lookup("b", tab);

    err += (ta == NULL);
    err += (tb == NULL);

    err += (strcmp(sa, ta) != 0);
    err += (strcmp(sb, tb) != 0);

    err += (SC_hash_rem("a", tab) != TRUE);
    err += (SC_hash_rem("b", tab) != TRUE);

    SC_rl_hash_table(tab);

/* alist */
    sa = SC_strsavef("string-a", "char*:TEST_1:sa_list");
    sb = SC_strsavef("string-b", "char*:TEST_1:sb_list");

    lsa = SC_add_alist(NULL, "a", SC_STRING_S, sa);
    lsb = SC_add_alist(lsa,  "b", SC_STRING_S, sb);
    err += (lsa == NULL);
    err += (lsb == NULL);

    err += (lsa->car != SC_assoc_entry(lsa, "a"));
    err += (lsb->car != SC_assoc_entry(lsb, "b"));
    
    ta = (char *) SC_assoc(lsb, "a");
    tb = (char *) SC_assoc(lsb, "b");
    err += (strcmp(sa, ta) != 0);
    err += (strcmp(sb, tb) != 0);

    lsb = SC_rem_alist(lsb, "a");
    lsb = SC_rem_alist(lsb, "b");
    err += (lsb != NULL);

    return(err);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
 
/* TEST_2 - test hash only functionality */

static int test_2()
   {

    return(0);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
 
/* TEST_3 - test alist only functionality */

static int test_3()
   {int err;
    char *sa, *sb;
    char *ta, *tb;
    pcons *lsa, *lsb, *lsc;

    err = 0;

    sa = SC_strsavef("string-a", "char*:TEST_3:sa");
    sb = SC_strsavef("string-b", "char*:TEST_3:sb");

    lsa = NULL;
    lsa = SC_add_alist(lsa, "a1", SC_STRING_S, sa);
    lsa = SC_add_alist(lsa, "a2", SC_STRING_S, sb);
    err += (lsa == NULL);

    lsb = NULL;
    lsb = SC_add_alist(lsb, "b1", SC_STRING_S, sa);
    lsb = SC_add_alist(lsb, "b2", SC_STRING_S, sb);
    err += (lsb == NULL);

    lsc = SC_append_alist(NULL, lsa);
    lsc = SC_append_alist(lsc, lsb);
    err += (lsc == NULL);

    ta = (char *) SC_assoc(lsc, "a1");
    tb = (char *) SC_assoc(lsc, "b2");
    err += (strcmp(sa, ta) != 0);
    err += (strcmp(sb, tb) != 0);

    lsc = SC_rem_alist(lsc, "a1");
    lsc = SC_rem_alist(lsc, "a2");
    lsc = SC_rem_alist(lsc, "b1");
    lsc = SC_rem_alist(lsc, "b2");
    err += (lsc != NULL);

    return(err);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
