/*
 * TSCCLTA.C - test SCCTLA.C routines
 *
 * Source Version: 2.0
 * Software Release #92-0043
 *
 */

#include "cpyright.h"

/***********************************************************************
* File        : tscctla.c - Test program for pact/score/scctla.c
* Functions   : tSC_firsttok
* Externals   : pact/score
* Machines    : phoenix.ocf
*
* Programmer  : Carolyn Sharp
* Created     : February 12, 1992
* Revised     : 
*
* Description : Test program for all the string and token functions
*               in scctla.c .
* Notes       : See tmm.c for the tests of memory management functions.
***********************************************************************/

#include "score.h" 

#define MAXTOK 32

main ()
   {int fail;

    fail = tSC_firsttok();

    return(fail ? 1 : 0);}


/***********************************************************************
* Function    : tSC_firsttok
* Test for    :  SC_firsttok
* Input       : tokfil = file of test tokens and expected results
*               debug = flag set in tokfil
* Output      : prints (failures/everything) if debug flag = (0/1)
* Externals   : fopen, fscanf, fclose, printf 
* Returns     : total number of failures detected
*
* Description : This function loops through a file of tokens 
*
***********************************************************************/

#define NUMTESTS 12

tSC_firsttok()
   {int fail, failsum, i;
    char *first, *expect;
    char *str[NUMTESTS];
    static char *tok[] = {NULL, NULL, "*", "*", "*",
			  "*abc", "*", "*abc",
			  "x", "x", "x", "x"};

    str[0]  = SC_strsavef("", "char*:TSCCTLA:str0");
    str[1]  = SC_strsavef(" ", "char*:TSCCTLA:str1");
    str[2]  = SC_strsavef("  *", "char*:TSCCTLA:str2");
    str[3]  = SC_strsavef(" *", "char*:TSCCTLA:str3");
    str[4]  = SC_strsavef("* ", "char*:TSCCTLA:str4");
    str[5]  = SC_strsavef("*abc", "char*:TSCCTLA:str5");
    str[6]  = SC_strsavef("* abc", "char*:TSCCTLA:str6");
    str[7]  = SC_strsavef("*abc ", "char*:TSCCTLA:str7");
    str[8]  = SC_strsavef("xyz", "char*:TSCCTLA:str8");
    str[9]  = SC_strsavef("xyz*", "char*:TSCCTLA:str9");
    str[10] = SC_strsavef("xyz *", "char*:TSCCTLA:str10");
    str[11] = SC_strsavef("xyz * ", "char*:TSCCTLA:str11");

    failsum  = 0;

    PRINT(STDOUT, "\nTokenize by \" y\\n\"\n");
    PRINT(STDOUT, "Input   \tFirst\tExpect\tRest\tStatus\n");
    for (i = 0; i < NUMTESTS; i++)
        {PRINT(STDOUT, "|%s|      \t",str[i]);

         first  = SC_firsttok(str[i], " y\n");
         expect = tok[i];

         if (first == NULL)
	    PRINT(STDOUT, "|nil|\t");
	 else
	    PRINT(STDOUT, "|%s|\t", first);

	 if (expect == NULL)
	    PRINT(STDOUT, "|nil|\t");
	 else
	    PRINT(STDOUT, "|%s|\t", expect);

	 PRINT(STDOUT, "|%s|\t", str[i]);

	 if ((first == NULL) && (expect == NULL))
	    fail = 0;
	 else if ((first == NULL) || (expect == NULL))
	    fail = 1;
	 else
	    fail = strcmp(first, expect);

	 PRINT(STDOUT, "%s\n", fail ? " Fail" : "  OK");

	 failsum += fail;};

/* report failures */
    if (failsum)
       PRINT(STDOUT, "\n%d failure%s in SC_regx_match \n", failsum,
	      ((failsum>1) ? "s" : "") );

    PRINT(STDOUT, "\n");

    return(failsum);}

