(define red  7)
(define blue 4)

(define MAJOR              1)
(define MINOR              2)
(define LABEL              3)
(define MAJOR_MINOR        4)
(define MAJOR_LABEL        5)
(define MINOR_LABEL        6)
(define MAJOR_MINOR_LABEL  7)
(define NO_TICKS           8)

(define RIGHT_OF_AXIS    9)
(define LEFT_OF_AXIS    10)
(define STRADDLE_AXIS   11)
(define ENDS            12)
(define NOTHING_ON_AXIS 13)

(define (axes dev tick-side label-side)
    (let* ((%pi (acos -1.0))
	   (twopi (* 2.0 %pi))
	   (dphi (/ %pi 180.0)))

	(define (angled-axis dev phi)
	    (let* ((cosa (cos phi))
		   (sina (sin phi))
		   (nphi (+ phi dphi)))
		(pg-clear-region dev 0.1 0.9 0.1 0.9)
		(pg-draw-axis dev
			      0.0 0.0 cosa sina
			      0.5 1.0
			      -1.0 1.0 
			      1.0  "%4.1f"
			      tick-side label-side
			      MAJOR_LABEL)
;		(if (<= phi twopi)
		    (angled-axis dev nphi)))
;)

	(angled-axis dev 0.0)))

(define devr (pg-make-device "SCREEN" "COLOR" "Axis Movie"))
(pg-open-device devr 0.000001 0.000001 0.4 0.4)
(pg-set-viewport! devr 0.2 0.8 0.2 0.8)
(pg-set-world-coordinate-system! devr -1.0 1.0 -1.0 1.0)
(pg-set-line-color! devr red)
(pg-set-text-color! devr blue)

(axes devr STRADDLE_AXIS RIGHT_OF_AXIS)
