/*
 * SXSET.C - set up routines for SX and SPDBX
 *
 * Source Version: 3.0
 * Software Release #92-0043
 *
 */

#include "cpyright.h"
 
#include "sx.h"

#define ELSE_IF(str, typ)                                                   \
    else if (strcmp(type, str) == 0)                                        \
       *((typ *) (var->val)) =  *((typ *) val)

#define PRIMITIVE_GETLN (*pr_gets)

#define EOI(str)                                                             \
   (((SS_PTR(str) != SS_BUFFER(str)) && (*(SS_PTR(str) - 1) == '\n')) ||     \
     (*SS_PTR(str) == '\0'))

char
 *SX_console_type;

REAL
 SX_console_x,
 SX_console_y,
 SX_console_width,
 SX_console_height;

static PFPChar
 pr_gets = NULL;

PFByte
 SX_plot_hook = NULL;

FILE
 *SX_command_log = NULL;

char
 *SX_command_log_name = NULL;

int
 SX_prefix_list[NPREFIX];

PDBfile
 *SX_vif;

g_file
 *SX_gvif;

object
 *SX_ovif;

char
 *SX_PDBFILE_S = "PDBfile",
 SX_err[MAXLINE];

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
 
/* SX_INSTALL_FUNCS - install the extended Scheme functions */
 
void SX_install_funcs()
   {PA_init_strings();

    SX_install_global_vars();

/* PDBLib related functions */
    SX_install_pdb_funcs();

#ifndef SPDBX_ONLY

/* PANACEA related functions */
    SX_install_panacea_funcs();

/* PGS related functions */
    SX_install_pgs_funcs();

/* PML related functions */
    SX_install_pml_funcs();

/* install the SX math handled functions */
   SX_mf_install();

/* pure SX functions */
   SX_install_global_funcs();

#endif

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SX_INIT - initialize SX */

void SX_init(code, vers)
   char *code, *vers;
   {

#ifndef SPDBX_ONLY

#ifndef MAC

/* connect the I/O functions */
    if (!PG_open_console("PACT SX", SX_console_type,
			 SX_background_color_white,
			 SX_console_x, SX_console_y,
			 SX_console_width, SX_console_height))
       if (SX_gr_mode && !SX_qflag)
	  printf("\nCannot connect to display\n");

#endif

#endif

/* scheme initializations */
    SS_init_scheme(code, vers);

    SS_init_cont();
    
/* SX initializations depending on scheme */
    SX_install_funcs();

    SX_vif  = PD_open_vif("SX_vif");
    SX_gvif = _SX_mk_file("virtual-internal",
			  SX_PDBFILE_S, SX_PDBFILE_S, SX_vif);
    SX_ovif = SX_mk_gfile(SX_gvif);

/* PDB initializations */
    pdb_wr_hook = _SX_hash_hook;
    _SX_init_hash_objects(SX_vif);

/* default formats */
    _PD_set_digits(SX_vif);
    _PD_set_format_defaults();

#ifndef SPDBX_ONLY

/* PANACEA initializations */
    _SX_var_tab = SS_mk_hash_table(PA_variable_tab);
    SS_UNCOLLECT(_SX_var_tab);
    if (SC_install("pa-variable-table",
		   _SX_var_tab, SS_POBJECT_S, SS_symtab) == NULL)
       SS_error("CAN'T INSTALL PANACEA DATA BASE - SX_INIT_SYSTEM",
                _SX_var_tab);

#endif

/* these lisp package special variables are initialized in all modes
 * give default values to the lisp package interface variables
 * set some default values for flags
 */
    SS_pr_ch_in   = SS_get_ch;
    SS_pr_ch_un   = SS_unget_ch;
    SS_pr_ch_out  = SS_put_ch;
    SS_print_flag = TRUE;
    SS_stat_flag  = TRUE;
    strcpy(SS_prompt, "SX-> ");

    SS_print_err_msg_hook = _SS_print_err_msg_a;
    SS_arg_hook           = _SX_args;
    SS_call_arg_hook      = _SX_call_args;

    SC_atof_hook   = _SC_atof;
    SC_strtod_hook = _SC_strtod;

    SC_convert_hook   = SX_convert;
    SC_container_hook = SX_container;

    SS_interactive = TRUE;

    SX_file_exist_action = FAIL;

    return;}

/*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*/

/* SX_PP_NAMES - pretty print a list of names
 *             - this should be generalized later
 */

object *SX_pp_names(argl)
   object *argl;
   {int i, j, k, n, m, jo, nc, nchar, ncol, ncc, nrow, nfcl, nfrw;
    char bf[81], **lst, *text, **slst;
    object *obj;

    n   = _SS_length(argl);
    lst = FMAKE_N(char *, n, "SX_PP_NAMES:lst");

    nchar = 0;
    for (i = 0; i < n; i++)
        {SX_GET_STRING_FROM_LIST(text, argl, NULL);
         lst[i] = text;
         nc     = strlen(text);
         nchar  = max(nchar, nc);};

    memset(bf, ' ', 80);
    bf[80] = '\0';

    nchar += 3;

    m    = n;
    ncol = 80/nchar;
    ncol = max(1, ncol);
    ncc  = (80 + ncol - 1)/ncol;
    nrow = (n + ncol - 1)/ncol;
    nfrw = n/ncol;
    if (nrow*ncol != n)
       nfcl = n - ncol*nfrw;
    else
       nfcl = ncol;
    slst = lst + nfcl*nrow;
    for (i = 0; i < nrow; i++)
        {for (j = 0; j < nfcl; j++)
             {k = j*nrow + i;
              m--;
              memcpy(&bf[j*ncc], lst[k], strlen(lst[k]));};

         for (jo = 0; jo < ncol - nfcl; jo++, j++)
             {k = jo*(nrow-1) + i;
              if (m <= 0)
                 continue;
              m--;
              memcpy(&bf[j*ncc], slst[k], strlen(slst[k]));};

         PRINT(stdout, "%s\n", bf);
         memset(bf, ' ', 80);};

    for (i = 0; i < n; i++)
        {SFREE(lst[i]);};
    SFREE(lst);

    return(SS_f);}

/*---------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _SX_GET_OBJECT_LENGTH - compute the number of items in a object */

int _SX_get_object_length(obj)
   object *obj;
   {switch (SC_arrtype(obj, -1))
       {case CONS         : return(_SS_length(obj));
        case VECTOR       : return(SS_VECTOR_LENGTH(obj));
        case SC_STRING_I  : return(SS_STRING_LENGTH(obj)+1);
        case SC_INTEGER_I :
        case SC_FLOAT_I   : return(1);
        case NULL_OBJ     : return(0);
        default           : return(0);};}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _SX_PREP_ARG - prepare the arg list by merging lists and
 *              - delistifying one element lists
 */

object *_SX_prep_arg(argl)
   object *argl;
   {object *acc, *lst, *obj;

/* because argl might be SS_Argl and since it is passed as an argument to
 * a function instead of being SS_Assign'd in the usual manner we MUST
 * protect against GC'ing it when the reference from SS_Argl is lost
 */
    SS_MARK(argl);
    SS_Assign(SS_Argl, SS_null);

/* make a copy of the arg list other people may be pointing at it */
    for (lst = SS_null, acc = argl; !SS_nullobjp(acc); acc = SS_cdr(acc))
        lst = SS_mk_cons(SS_car(acc), lst);
    SS_MARK(lst);

    acc = SS_null;
    while (!SS_nullobjp(lst))
       {obj = SS_car(lst);
        if (SS_consp(obj))
           {SS_Assign(acc, _SS_append(obj, acc));}
        else
           {SS_Assign(acc, _SS_append(SS_mk_cons(obj, SS_null), acc));};

/* this frees the cons we made above */
        SS_Assign(lst, SS_cdr(lst));};

/* undo the additional reference that was added at the beginning */
    SS_Assign(argl, SS_null);

    return(acc);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SX_NEXT_PREFIX - return the index of the next available menu prefix */

int SX_next_prefix()
   {int i;
    static int j = 0;

    for (i = 0; i < NPREFIX; i++)
        if (SX_prefix_list[i] == 0)
           return(i);

    return(j++);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SX_GET_CH - the do it right character reader
 *           - must get the next character from the given stream
 */

int SX_get_ch(str, ign_ws)
   object *str;
   int ign_ws;
   {char *t;
    int c;
    FILE *s;

    if (pr_gets == NULL)
       if (PG_console_device == NULL)
	  pr_gets = io_gets_hook;
       else
	  pr_gets = PG_wind_fgets;

    s = SS_INSTREAM(str);

    while (TRUE)
       {if (EOI(str))
           {if (s == stdin)
               {PG_make_device_current(PG_console_device);
                t = PRIMITIVE_GETLN(SS_BUFFER(str), MAXLINE, stdin);
                if (t == NULL)
                   continue;

/* the \r check is for the benefit of the MAC */
                if ((*t == '\n') || (*t == '\r'))
                   {if ((SX_autoplot == ON) && (SX_plot_hook != NULL))
                       (*SX_plot_hook)();
                    return('\n');};}

            else if (s == NULL)
               return(EOF);

            else
               t = PRIMITIVE_GETLN(SS_BUFFER(str), MAXLINE, s);

            if (t == NULL)
               {*SS_PTR(str) = (char) EOF;
                return(EOF);}
            else 
               SS_PTR(str) = SS_BUFFER(str);};

        c = *SS_PTR(str)++;

        if (c == EOF)
           SS_PTR(str)--;

        if (ign_ws)
           {switch (c)
               {case '\n':

#ifndef MACPLUS
                case '\r':
#endif

                case '\t':
                case ' ' : break;
                case ';' : while ((c = *SS_PTR(str)++) != '\0')
                              {if (c == EOF)
                                  return(c);
                               else if ((c == '\n') || (c == '\r'))
                                  break;};
                           break;
                default  : return(c);};}
        else
           return(c);};}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
