;
; ANNOTATE.SCM - handle textual annotations for ULTRA
;
; Source Version: 4.0
; Software Release #92-0043
;
; #include <pact-copyright.h>
;

;(define-global annotation-list '())

;--------------------------------------------------------------------------
;--------------------------------------------------------------------------

; ANNOT - add an annotation to the screen
;       - arguments:
;       -    txt       - the text of the annotation
;       -    [color] - the color of the annotation text
;       -    [x, y]  - the location of the lower left insertion point of
;       -              the text block (NDC)

(define (annot txt . rest)
    "Procedure: annotate a plot writing text at a point specified in
     normalized coordinates.
     Usage: annot <text> [<color> [<xmin> <xmax> <ymin> <ymax>]]"
    (let* ((in (if rest (length rest) 0))
	   (clr (if (> in 0) (list-ref rest 0) white))
	   (x1  (if (> in 1) (list-ref rest 1)))
	   (x2  (if (> in 2) (list-ref rest 2)))
	   (y1  (if (> in 3) (list-ref rest 3)))
	   (y2  (if (> in 4) (list-ref rest 4))))

      (if (defined? screen-window)
	  (begin
	    (if (> in 4)
		(add-annotation screen-window txt clr x1 x2 y1 y2))
	    (if (< in 2)
		(add-annotation screen-window txt clr))
	    (if (and (> in 1) (< in 5))
		(printf nil "Insufficient number of coordinates, or color not specified\n\n"))))))

;--------------------------------------------------------------------------
;--------------------------------------------------------------------------
