/*
 * ULTRA.C - the portable presentation, analysis and manipulation tool
 *
 * Source Version: 4.0
 * Software Release #92-0043
 *
 */

#include "cpyright.h"
 
#include "ultra.h"
#include "gsrast.h"

typedef DECLFPTR(byte, PFReplot, (void));

#ifdef DEBUG

int
 heapch;

#endif

extern void
 SC_DECLARE(_SX_end_prog, (void *d, PG_event *ev));

REAL
 *UL_buf1x,
 *UL_buf1y,
 *UL_buf2x,
 *UL_buf2y;

REAL
 UL_derivative_tolerance;

C_procedure
 *Curve_Proc;

object
 *UL_ann_lst,
 *UL_window;

static char
 _UL_bf[MAXLINE];

int
 SC_DECLARE(UL_rd_scm, (char *name)),
 SC_DECLARE(_UL_rd_scm, (byte));

static char
 *SC_DECLARE(_UL_reproc_in, (char *line));

static void
 SC_DECLARE(UL_init_env, (byte)),
 SC_DECLARE(_UL_args, (object *obj, byte *v, int type)),
 SC_DECLARE(_UL_parse, (object *strm)),
 SC_DECLARE(_UL_expand_prefix, (char *s)),
 SC_DECLARE(_UL_read, (object *strm));
#if 0
 SC_DECLARE(UL_expose_event_handler, 
            (PG_device *dev, PG_event *ev)),
 SC_DECLARE(UL_update_event_handler, 
            (PG_device *dev, PG_event *ev)),
 SC_DECLARE(UL_motion_event_handler, 
            (PG_device *dev, PG_event *ev)),
 SC_DECLARE(UL_default_event_handler, 
            (PG_device *dev, PG_event *ev)),
#endif

static int
 SC_DECLARE(_UL_print, (byte));

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* MAIN - start up a fun filled session of ULTRA right here */

int main(argc, argv)
   int argc;
   char *argv[];
   {int i, load_sch, load_data, load_init, load_rc;
    int commnd_flag;
    char *s, *file_name, t[MAXLINE], commnd[MAXLINE];

#ifdef HAVE_THREADS
    PD_init_threads(1, NULL);
#endif

/* start out with interrupts off until we are set
 * that is until we are ready to process the command line args
 */
    PG_IO_INTERRUPTS(FALSE);

    SC_init("ABORT: Gross Initialization Error", (PFByte) _UL_quit,
            TRUE, SS_interrupt_handler,
            FALSE, NULL, 0);

#ifdef HAVE_JPEGLIB
/* register the JPEG device */
    PG_register_device("JPEG", PG_setup_jpeg_device);
#endif

    commnd_flag = FALSE;
    load_sch    = 0;
    load_data   = 0;
    load_init   = TRUE;
    load_rc     = TRUE;

    SS_init_scheme(CODE, VERSION);
    SS_init_stack();
    SS_init_cont();

    SC_init_path(1, "ULTRA");

/* ULTRA initializations not depending on scheme */
    UL_init_view();
    UL_init_hash();
    UL_install_global_vars();
    UL_install_funcs();

/* ULTRA initializations depending on scheme */
    UL_install_scheme_funcs();
    UL_init_curves();

    UL_init_env();

/* process the command line arguments */
    for (i = 1; i < argc; i++)
        if (argv[i][0] == '-')
           {switch (argv[i][1])
               {case 'i' :                       /* IO not interrupt driven */
		     PG_IO_INTERRUPTS(FALSE);
                     break;
                case 'l' :                              /* load Scheme file */
                     load_sch = ++i;
                     break;
                case 'n' :                          /* don't load init file */
                     load_init = FALSE;
                     break;
                case 'r' :                          /* don't load .rc file */
                     load_rc   = FALSE;
                     break;
                case 's' :                                   /* Scheme mode */
                     SX_gr_mode = FALSE;
		     PG_IO_INTERRUPTS(FALSE);
                     break;
                case 'u' :                                    /* Ultra mode */
                     SX_gr_mode = TRUE;
                     break;};}
        else if (argv[i][0] == '(')
           {commnd_flag = TRUE;
            strcpy(commnd, " ");
            for ( ; i < argc; i++)
                {strcat(commnd, argv[i]);
                 strcat(commnd, " ");};}
        else
           {load_data = i;
            file_name = argv[i];};

#ifndef MAC

    if (!commnd_flag)
       UL_print_banner();

#endif

    SX_autoplot = OFF;
    if (load_init)

/* load the SCHEME level ULTRA functionality */
       {if (_SC_query_file("ultra.scm", "r", "ascii"))
           strcpy(t, "ultra.scm");
        else
           {s = SC_search_file(SC_path, "ultra.scm");
            if (s == NULL)
               {PRINT(stderr, "Can't find ultra.scm\n");

#ifndef MAC
                PRINT(stderr, "Check ULTRA environment variable\n\n");
#endif
                _UL_quit(ABORT);};
            strcpy(t, s);};

        SS_load_scm(t);

/* load the init file */
        if (load_rc == TRUE)
           s = SC_search_file(SC_path, ".ultrarc");
        if ((s == NULL) || !_SC_query_file(s, "r", "ascii"))
           {s = SC_search_file(SC_path, "ultra.ini");
            if (s == NULL)
               {PRINT(stderr, "Can't find .ultrarc or ultra.ini\n");
#ifndef MAC
                PRINT(stderr, "Check ULTRA environment variable\n\n");
#endif
                _UL_quit(ABORT);};

            
            if (!_SC_query_file(s, "r", "ascii"))
               {PRINT(stderr, "Can't open .ultrarc or ultra.ini\n");
                _UL_quit(ABORT);};};

        SS_load_scm(s);};

/* read the curves from the optionally specified data file
 * all data files should be read into the environment created by
 * any loaded SCHEME files, hence this comes last!
 */
    if (load_data != 0)
       {s = SC_search_file(NULL, file_name);
        if (s != NULL)
           UL_rd_scm(file_name);
        else
           PRINT(STDOUT, "\n\nFile %s not found\n", file_name);};

    SX_autoplot = ON;
    if (SX_gr_mode)
       UL_mode_graphics();
    else
       UL_mode_text();

#ifdef MAC

    if (!commnd_flag)
       UL_print_banner();

/* this is a kludge to make the "Quit" menu option work */
    PG_register_callback("End", _SX_end_prog);

#endif

    PG_expose_device(PG_console_device);

    SS_nsave    = 0;
    SS_nrestore = 0;
    SS_nsetc    = 0;
    SS_ngoc     = 0;

    SC_mem_stats_set(0L, 0L);

/* read the optionally specified load file
 * on the other hand you'd like to be able to have functions that
 * specifically operate on the data that has been loaded
 */ 
    if (load_sch != 0)
       SS_load_scm(argv[load_sch]);

    if (commnd_flag)
       return(!SS_run(commnd));
    else
       SS_repl();

    return(TRUE);}
        
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* UL_RD_SCM - do a SCHEME level rd with error protection */

int UL_rd_scm(name)
   char *name;
   {strcpy(_UL_bf, name);

    return(SS_err_catch(_UL_rd_scm, NULL));}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _UL_RD_SCM - do a SCHEME level rd with error protection */

int _UL_rd_scm()
   {SS_call_scheme("rd",
                   SC_STRING_I, _UL_bf,
                   0);

    return(TRUE);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* UL_INIT_VIEW - initialize the plot parameters */

void UL_init_view()
   {int j;

    SX_default_npts      = 100;
    SX_gr_mode           = TRUE;

    SX_plot_flag         = TRUE;

    SX_console_x         = 0.0;
    SX_console_y         = 0.0;
    SX_console_width     = 0.33;
    SX_console_height    = 0.33;
    SX_gxmax             = 1.0;
    SX_gxmin             = 0.0;
    SX_gymax             = 1.0;
    SX_gymin             = 0.0;
    SX_view_x            = 0.18;
    SX_view_y            = 0.18;
    SX_view_width        = 0.75;
    SX_view_height       = 0.75;
    SX_view_aspect       = 1.0;
    SX_window_x          = 0.5;
    SX_window_y          = 0.1;
    SX_window_width      = 0.4;
    SX_window_height     = 0.4;
    SX_window_x_PS       = 0.0;
    SX_window_y_PS       = 0.0;
    SX_window_width_P    = 1.0;
    SX_window_height_P   = 1.0;
    SX_window_width_PS   = 0.0;
    SX_window_height_PS  = 0.0;
    SX_window_x_CGM      = 0.0;
    SX_window_y_CGM      = 0.0;
    SX_window_width_CGM  = 0.0;
    SX_window_height_CGM = 0.0;
    SX_window_x_MPEG     = 0.0;
    SX_window_y_MPEG     = 0.0;
    SX_window_width_MPEG = 512.0;
    SX_window_height_MPEG= 512.0;
#ifdef HAVE_JPEGLIB
    SX_window_x_JPEG     = 0.0;
    SX_window_y_JPEG     = 0.0;
    SX_window_width_JPEG = 512.0;
    SX_window_height_JPEG= 512.0;
#endif

    SX_console_type     = SC_strsavef("MONOCHROME",
                          "char*:UL_INIT_VIEW:console_type");
    SX_ascii_output_format = SC_strsavef("%13.6e",
                             "char*:UL_INIT_VIEW:format");

    SX_display_name  = SC_strsavef("WINDOW",
                       "char*:UL_INIT_VIEW:display_name");
    SX_display_type  = SC_strsavef("COLOR",
                       "char*:UL_INIT_VIEW:display_type");
    SX_display_title = SC_strsavef("ULTRA II",
                       "char*:UL_INIT_VIEW:display_title");

    UL_derivative_tolerance = 2.0e-2;

    SS_interactive = FALSE;
    SS_print_flag  = FALSE;
    SS_stat_flag   = FALSE;

    SX_command_log_name = SC_strsavef("ultra.log",
                          "char*:UL_INIT_VIEW:log_name");

/* be able to access remote files */
    PC_io_connect(PC_REMOTE);

    for (j = 0; j < NDISPLAY; j++)
        SX_data_index[j] = -1;

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* UL_INIT_ENV - setup the overall ULTRA environment */

static void UL_init_env()
   {int i;
    extern void SX_install_pgs_iob();

/* initialize the prefix list */
    for (i = 0; i < NPREFIX; i++)
        SX_prefix_list[i] = 0;

    SX_pui_file  = SC_strsavef("ultra.pui", "char*:UL_INIT_ENV:file");
    SX_GRI_title = SC_strsavef("ULTRA Controls",
                   "char*:UL_INIT_ENV:title");

    PG_register_callback("Replot", (PFByte) UL_plot);

    PG_register_variable("Plot Type", SC_INTEGER_S,
			 &_PG_plot_type, NULL, NULL);

/* add the SX annotation stuff */
    SX_install_pgs_iob();

/* these lisp package special variables are initialized in all modes */
    SS_print_err_msg_hook = _SS_print_err_msg_a;
    SS_arg_hook           = _UL_args;
    SX_plot_hook          = (PFByte) UL_plot;

    SC_atof_hook   = _SC_atof;
    SC_strtod_hook = _SC_strtod;

/* you really want to do interrupt based terminal I/O so as to not
 * have ULTRA hog the CPU while polling for input (especially on a CRAY)
 */
    PG_IO_INTERRUPTS(TRUE);

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* UL_MODE_TEXT - go into text mode and
 *              - return "#t" if text mode was already in effect
 *              - else return "#f"
 */

object *UL_mode_text()
   {object *ret;

    if (PG_console_device == NULL)
       PG_open_console("ULTRA II", SX_console_type, SX_background_color_white,
                       SX_console_x, SX_console_y,
                       SX_console_width, SX_console_height);

    if (SX_graphics_device != NULL)
       {PG_clear_window(SX_graphics_device);
        PG_close_device(SX_graphics_device);
        SX_graphics_device = NULL;

        SX_gr_mode   = FALSE;
        SX_plot_flag = FALSE;

        ret = SS_t;}
    else
        ret = SS_f;

/* give default values to the lisp package interface variables */
    SS_post_read_hook  = NULL;
    SS_post_eval_hook  = NULL;
    SS_post_print_hook = NULL;
    SS_pr_ch_in        = SS_get_ch;
    SS_pr_ch_un        = SS_unget_ch;
    SS_pr_ch_out       = SS_put_ch;

#ifdef MAC
    putln = (PFfprintf) SX_fprintf;
    getln = (PFfgets) PG_wind_fgets;
#else
    putln = (PFfprintf) SS_printf;
    getln = io_gets_hook;
#endif

    strcpy(SS_prompt, "S-> ");

    return(ret);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* UL_MODE_GRAPHICS - go into graphics mode
 *                  - return "#t" if graphics mode was already in effect
 *                  - else return "#f"
 */

object *UL_mode_graphics()
   {object *ret;
    double win_height;
    static object *scrwin = NULL;

    if (PG_console_device == NULL)
       {if (!PG_open_console("ULTRA II", SX_console_type,
                             SX_background_color_white,
                             SX_console_x, SX_console_y,
                             SX_console_width, SX_console_height))
           {PRINT(STDOUT, "\nCannot connect to display\n\n");};}

    if (SX_graphics_device == NULL)
       {strcpy(SS_prompt, "U-> ");
        strcpy(SS_ans_prompt, "");

        SS_post_read_hook  = (PFVoid) _UL_read;
        SS_post_eval_hook  = (PFVoid) _UL_parse;
        SS_post_print_hook = (PFInt) _UL_print;
        SS_pr_ch_in        = (PFInt) SX_get_ch;
        putln              = (PFfprintf) SX_fprintf;
	if (PG_console_device == NULL)
      	   getln = io_gets_hook;
	else
	   getln = (PFfgets) PG_wind_fgets;

        SX_gr_mode         = TRUE;
        SX_graphics_device = PG_make_device(SX_display_name, SX_display_type,
                                            SX_display_title);

	if (SX_graphics_device != NULL)
	   {if (scrwin == NULL)
	       {scrwin = SX_mk_graphics_device(SX_graphics_device);
		SS_install_cv("screen-window", scrwin, SS_OBJECT_I);
		SS_UNCOLLECT(scrwin);}
 	    else
	       scrwin->val = (byte *) SX_graphics_device;

/* map the ultra graphics state onto the device */
	    UL_set_graphics_state(SX_graphics_device);

	    SX_graphics_device->view_y      = (SX_view_y + SX_label_space)/
                                              (1.0 + SX_label_space);
	    SX_graphics_device->view_height = SX_view_height/
                                              (1.0 + SX_label_space);
	    win_height = (1.0 + SX_label_space)*SX_window_height;

/* open the device now */
	    PG_open_device(SX_graphics_device, SX_window_x, SX_window_y,
			   SX_window_width, win_height);
	    PG_make_device_current(SX_graphics_device);
	    SX_border_width = SX_graphics_device->border_width;
	    PG_set_window(SX_graphics_device, 0.0, 1.0, 0.0, 1.0);
	    PG_release_current_device(SX_graphics_device);

	    PG_set_default_event_handler(SX_graphics_device,
					 SX_default_event_handler);

	    PG_set_motion_event_handler(SX_graphics_device,
					SX_motion_event_handler);
	    
	    PG_set_expose_event_handler(SX_graphics_device,
					SX_expose_event_handler);

	    PG_set_update_event_handler(SX_graphics_device,
					SX_update_event_handler);

/* remember the window size and position in pixels */
	    SX_window_height_P = SX_graphics_device->window_height;
	    SX_window_width_P  = SX_graphics_device->window_width;
	    SX_window_x_P      = SX_graphics_device->window_x;
	    SX_window_y_P      = SX_graphics_device->window_y;

	    if (PG_console_device != NULL)
	       PG_expose_device(PG_console_device);};

        ret = SS_t;}
    else
       ret = SS_f;

    PG_make_device_current(PG_console_device);

    return(ret);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* UL_SET_GRAPHICS_STATE - map the ultra graphics state variables onto the
 *                       - given device before initialization or plotting
 */

void UL_set_graphics_state(d)
   PG_device *d;
   {d->autodomain             = SX_autodomain;
    d->autoplot               = SX_autoplot;
    d->autorange              = SX_autorange;
    d->background_color_white = SX_background_color_white;

    if (CGM_DEVICE(d) && (SX_cgm_background_color != -1))
       d->background_color_white = SX_cgm_background_color;

    d->border_width           = SX_border_width;
    d->data_id                = SX_data_id;
    d->gprint_flag            = TRUE;
    d->grid                   = SX_grid;

    d->marker_scale           = SX_marker_scale;
    d->marker_orientation     = SX_marker_orientation;

    d->botspace               = SX_botspace;
    d->gxmin                  = SX_gxmin;
    d->gxmax                  = SX_gxmax;
    d->gymin                  = SX_gymin;
    d->gymax                  = SX_gymax;
    d->leftspace              = SX_leftspace;
    d->rightspace             = SX_rightspace;
    d->topspace               = SX_topspace;
    d->view_aspect            = SX_view_aspect;
    d->view_height            = SX_view_height;
    d->view_width             = SX_view_width;
    d->view_x                 = SX_view_x;
    d->view_y                 = SX_view_y;
    d->window_height          = SX_window_height_P;
    d->window_width           = SX_window_width_P;

    PG_set_axis_log_scale(d, SX_x_log_scale, SX_y_log_scale);
    PG_set_font(d, _PG_axis_type_face, SX_plot_type_style, SX_plot_type_size);

    if (!POSTSCRIPT_DEVICE(d))
       {d->window_x = SX_window_x_P;
        d->window_y = SX_window_y_P;};

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _UL_ARGS - get a C level data item from a single Scheme object */

static void _UL_args(obj, v, type)
   object *obj;
   byte *v;
   int type;
   {int *pi;

    switch (type)
       {case UL_CURVE_INDEX_I :
             if (SX_curvep_a(obj))
                {pi  = (int *) v;
                 *pi = SX_get_curve(obj);}
             else if (SS_integerp(obj))
                {pi = (int *) v;
                 *pi = SX_number[*SS_GET(int, obj)];}
             else
                SS_error("OBJECT NOT CURVE - _UL_ARGS", obj);
             break;

        case UL_DATA_ID_I :
             *(char *) v = (char) toupper((int) *SS_get_string(obj));
             break;

        default :
             _SX_args(obj, v, type);};

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _UL_PARSE - determine whether or not to reprocess the input for Ultra
 *           - this is the real worker for the SS_post_eval_hook
 *           - since this SS_evobj is not the same as in SS_REPL
 *           - it should be SS_MARK'd as being an additional pointer to its
 *           - respective object
 */

static void _UL_parse(strm)
   object *strm;
   {

    SX_parse((PFReplot) UL_plot, _UL_reproc_in, strm);

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _UL_REPROC_IN - reprocess the contents of the input buffer
 *               - treat the contents of the buffer as an implicit list
 *               - by effectively wrapping parens about the contents of
 *               - the buffer
 */

static char *_UL_reproc_in(line)
   char *line;
   {static char command[MAXLINE];

    if (!_SX_split_command(command, line))
       return(NULL);

    else
       {if (!_SX_expand_expr(command))
           SS_error("SYNTAX ERROR - _SX_REPROC_IN", SS_null);

        _UL_expand_prefix(command);

/* if it's already a list tell the parser to do nothing - it's already
 * done everything necessary
 */
        if (command[0] == '(')
           return(NULL);
        else
	   _SX_wrap_paren("(", command, ")");

        if (SX_command_log != NULL)
           PRINT(SX_command_log, "%s\n", command);

        return(command);};}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _UL_EXPAND_PREFIX - expand prefix expressions in referring to menu items
 *                   - Because of possible user defined synonyms, this must
 *                   - be done for every command, not just select. This step
 *                   - could come later and be applied only to number lists,
 *                   - if range expansion were moved to the handlers.
 */

static void _UL_expand_prefix(s)
   char *s;
   {char t[MAXLINE], token[MAXLINE];
    char *sp, *tp, *rp;
    int flag, index;

    strcpy(t, s);
    sp  = s;

    while ((tp = SC_firsttokq(t, " \t\n\r","\"")) != NULL)
       {if ((*tp >= 'a') && (*tp <= 'z')
            && (SX_prefix_list[*tp - 'a'] > 0)
            && (*(tp+1) == '.'))
           {if ((rp = strchr(tp+2, ')')))
               *rp = '\0';
            if ((flag = SC_intstrp(tp+2, 10)))
               index = atoi(tp+2);
            if (rp)
               *rp = ')';
            if (flag && rp)
               sprintf(token, "(pre %c %d))", *tp, index);
            else if (flag)
               sprintf(token, "(pre %c %d)", *tp, index);
            else
               strcpy(token, tp);}
        else
           strcpy(token, tp);

        sprintf(sp, "%s ", token);
        sp += strlen(token) + 1;}

    *(sp - 1) = '\0';

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _UL_READ - this is the SS_post_read_hook function for Ultra */

static void _UL_read(strm)
   object *strm;
   {

    return;}
    
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _UL_PRINT - the SS_post_print_hook function for Ultra */

static int _UL_print()
   {if (PG_console_device != NULL)
       PG_console_device->gprint_flag = TRUE;

    return(TRUE);}

#if 0
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* UL_EXPOSE_EVENT_HANDLER - handle expose events  */

static void UL_expose_event_handler(dev, ev)
   PG_device *dev;
   PG_event *ev;
   {UL_motion_event_handler(dev, ev);

/*
    UL_plot();
*/

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* UL_MOTION_EVENT_HANDLER - handle motion events  */

static void UL_motion_event_handler(dev, ev)
   PG_device *dev;
   PG_event *ev;
   {if (SX_show_mouse_location)
       PG_print_pointer_location(dev,
                                 SX_show_mouse_location_x,
                                 SX_show_mouse_location_y,
                                 TRUE);
    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* UL_UPDATE_EVENT_HANDLER - handle update events  */

static void UL_update_event_handler(dev, ev)
   PG_device *dev;
   PG_event *ev;
   {int width, height, ncol;

    PG_make_device_current(dev);

    SX_window_height_P = dev->window_height;
    SX_window_width_P  = dev->window_width;
    SX_window_x_P      = dev->window_x;
    SX_window_y_P      = dev->window_y;

    PG_query_screen(dev, &width, &height, &ncol);
    SX_window_width  = SX_window_width_P/width;
    SX_window_height = SX_window_height_P/(width*(1 + SX_label_space)); /* I really mean the width */

    SX_window_x = SX_window_x_P/width;
    SX_window_y = SX_window_y_P/width;           /* I really mean the width */

    UL_plot();

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* UL_DEFAULT_EVENT_HANDLER - handle events that get through to here */

static void UL_default_event_handler(dev, ev)
   PG_device *dev;
   PG_event *ev;
   {UL_motion_event_handler(dev, ev);

    return;}

#endif
/*--------------------------------------------------------------------------*/

/*                       CURVE MANAGEMENT ROUTINES                          */

/*--------------------------------------------------------------------------*/

/* UL_INIT_CURVES - initialize the curve data and references */

void UL_init_curves()
   {int i;
    char s[2], t[2];
    procedure *pp;

    SX_N_Curves = 0;
    SX_enlarge_dataset();

    s[1] = '\0';
    t[1] = '\0';

    Curve_Proc          = FMAKE(C_procedure,
                          "UL_INIT_CURVES:Curve_Proc");
    Curve_Proc->proc    = UL_curve_eval;
    Curve_Proc->handler = SS_sargs;

/* initialize the curve reference variables, procedures, and objects */
    for (i = 0; i < NDISPLAY; i++)
        {s[0] = i + 'a';
         t[0] = i + 'A';

         SX_crv_obj[i] = SS_mk_variable(s, SS_null);
         SS_UNCOLLECT(SX_crv_obj[i]);

         pp        = FMAKE(procedure, "UL_INIT_CURVES:pp");
         pp->type  = SS_PR_PROC;
         pp->doc   = NULL;
         pp->name  = SC_strsavef(t, "char*:UL_INIT_CURVES:name");
         pp->trace = FALSE;
         pp->proc  = (object *) Curve_Proc;

         SX_crv_proc[i] = SS_mk_proc_object(pp);
         SS_UNCOLLECT(SX_crv_proc[i]);

         SX_crv_varbl[i] = SS_mk_variable(s, SX_crv_obj[i]);
         SS_UNCOLLECT(SX_crv_varbl[i]);

         SS_GET(variable, SX_crv_obj[i])->value = SX_crv_varbl[i];

         if (SC_install(s, SX_crv_obj[i], SS_OBJECT_S, SS_symtab) == NULL)
            longjmp(SC_top_lev, ABORT);
         if (SC_install(t, SX_crv_obj[i], SS_OBJECT_S, SS_symtab) == NULL)
            longjmp(SC_top_lev, ABORT);};

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* UL_SET_ID - change the data-id of the given curve */

object *UL_set_id(argl)
   object *argl;
   {char id;
    int iold, jnew, jold;
    object *obj;

    SX_prep_arg(argl);

    iold    = -1;
    id = '\0';
    SS_args(argl,
            UL_CURVE_INDEX_I, &iold,
            UL_DATA_ID_I, &id,
            0);

    if (iold < 0)
       SS_error("BAD CURVE ARGUMENT - UL_SET_ID", argl);

    if ((id == '\0') || (id < 'A') || (id > 'Z'))
       SS_error("BAD ID ARGUMENT - UL_SET_ID", argl);

    if (_SX_curvep(&id))
       SS_error("SPECIFIED ID ALREADY IN USE - UL_SET_ID", argl);

    jnew = id - 'A';
    jold = SX_dataset[iold].id - 'A';

/*  sever the connection with the old curve */
    obj = SX_crv_obj[jold];
    SS_VARIABLE_VALUE(obj) = SX_crv_varbl[jold];
    SS_VARIABLE_NAME(obj)  = SS_VARIABLE_NAME(SX_crv_varbl[jold]);

    SX_data_index[jold] = -1;

/*  make the connection with the new curve */
    SX_dataset[iold].id  = id;
    SX_data_index[jnew] = iold;

    return(SX_mk_curve_proc(iold));}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* UL_THRU - return an expanded list of curves */

object *UL_thru(argl)
   object *argl;
   {object *ret = SS_null;

    SX_prep_arg(argl);

    if (_SS_numberp(SS_car(argl)))
       {int first = 0, last = 0, id;
        
        SS_args(argl,
                SC_INTEGER_I, &first,
                SC_INTEGER_I, &last,
                0);

        if (first < 1)
           SS_error("FIRST ARGUMENT NOT A VALID CURVE NUMBER - UL_THRU", argl);

        if (last < 1)
           SS_error("SECOND ARGUMENT NOT A VALID CURVE NUMBER - UL_THRU", argl);

        if (first <= last)
           {last = min(last, SX_n_curves_read);
            for (id = first; id <= last; id++)
                SS_Assign(ret, SS_mk_cons(SS_mk_integer((BIGINT)id), ret));}
        else
           {first = min(first, SX_n_curves_read);
            for (id = first; id >= last; id--)
                SS_Assign(ret, SS_mk_cons(SS_mk_integer((BIGINT)id), ret));};}

    else
       {char first = '\0', last = '\0', id;

        SS_args(argl,
                UL_DATA_ID_I, &first,
                UL_DATA_ID_I, &last,
                0);

        if ((first < 'A') || (first > 'Z'))
           SS_error("FIRST ARGUMENT NOT A VALID DATA-ID - UL_THRU", argl);

        if ((last < 'A') || (last > 'Z'))
           SS_error("SECOND ARGUMENT NOT A VALID DATA-ID - UL_THRU", argl);

        if (first <= last)
           {for (id = first; id <= last; id++)
                if (_SX_curvep(&id))
                   SS_Assign(ret, SS_mk_cons(SX_crv_obj[id - 'A'], ret));}
        else
           {for (id = first; id >= last; id--)
                if (_SX_curvep(&id))
                   SS_Assign(ret, SS_mk_cons(SX_crv_obj[id - 'A'], ret));};};

    SX_prep_ret(ret);

    return(ret);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* UL_COPY_CURVE - make a copy of the curve indexed by j
 *               - and return the objectified curve label
 */

object *UL_copy_curve(j)
   int j;
   {int i, k;
    REAL *xpi, *ypi, *xpj, *ypj;

    i = SX_next_space();

    SX_assign_next_id(i, (PFVoid) UL_plot);

    SX_dataset[i].text      = SC_strsavef(SX_dataset[j].text,
                              "char*:UL_COPY_CURVE:text");
    SX_dataset[i].xmin      = SX_dataset[j].xmin;
    SX_dataset[i].xmax      = SX_dataset[j].xmax;
    SX_dataset[i].ymin      = SX_dataset[j].ymin;
    SX_dataset[i].ymax      = SX_dataset[j].ymax;
    SX_dataset[i].n         = SX_dataset[j].n;
    SX_dataset[i].file_info = SX_dataset[j].file_info;
    SX_dataset[i].file_type = SX_dataset[j].file_type;
    SX_dataset[i].modified  = FALSE;

    if (SX_dataset[j].file != NULL)
       SX_dataset[i].file = SC_strsavef(SX_dataset[j].file,
                            "char*:UL_COPY_CURVE:file");
    else
       SX_dataset[i].file = NULL;

    xpj = SX_dataset[j].xp;
    ypj = SX_dataset[j].yp;
    xpi = SX_dataset[i].xp = FMAKE_N(REAL, SX_dataset[j].n,
                             "UL_COPY_CURVE:xpi");
    ypi = SX_dataset[i].yp = FMAKE_N(REAL, SX_dataset[j].n,
                             "UL_COPY_CURVE:ypi");
    if (xpi == NULL || ypi == NULL)
       SS_error("INSUFFICIENT MEMORY - UL_COPY_CURVE", SS_null);

/* copy data if it is already in memory */
    if ((xpj != NULL) && (ypj != NULL))
       for (k = 0; k < SX_dataset[j].n; k++)
           {*xpi++ = *xpj++;
            *ypi++ = *ypj++;};

    PG_set_line_info(SX_dataset[i].info, CARTESIAN, CARTESIAN, SOLID,
		     FALSE, 0, _SX_next_color(SX_graphics_device), 0, 0.0);

    return(SX_mk_curve_proc(i));}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* UL_EXTRACT_CURVE - extract a curve from the given curve 
 *                  - from xstart to xstop by xstep
 */

object *UL_extract_curve(argl)
   object *argl;
   {int i, j, k, l, n;
    REAL *xpi, *ypi, *xpj, *ypj, *xpjtmp, *ypjtmp;
    REAL xstart, xstop, xstep, xv, yv, ymn, ymx;
    REAL xta, xtb, xtc, yta, ytb, tmp;
    char s[MAXLINE];
    object *crv;
    int irev = FALSE;

    crv    = NULL;
    xstart = 0.0;
    xstop  = 1.0;
    xstep  = 0.1;
    SS_args(argl,
            SS_OBJECT_I, &crv,
            SC_REAL_I, &xstart,
            SC_REAL_I, &xstop,
            SC_REAL_I, &xstep,
            0);

    j = SX_get_curve(crv);
    i = SX_next_space();
    n = 1 + (1.0 + TOLERANCE)*ABS(xstop - xstart)/xstep;

    xpj = SX_dataset[j].xp;
    ypj = SX_dataset[j].yp;

    if ((SX_dataset[j].xmin == xpj[SX_dataset[j].n - 1]) &&
        (SX_dataset[j].xmax == xpj[0]))
       {xpjtmp = FMAKE_N(REAL, SX_dataset[j].n,
                         "UL_EXTRACT_CURVE:xpjtmp");
        ypjtmp = FMAKE_N(REAL, SX_dataset[j].n,
                         "UL_EXTRACT_CURVE:ypjtmp");
        for (l = 0; l < SX_dataset[j].n; l++)
            {xpjtmp[l] = xpj[SX_dataset[j].n - l - 1];
             ypjtmp[l] = ypj[SX_dataset[j].n - l - 1];}
        xpj = xpjtmp;
        ypj = ypjtmp;
        irev = TRUE;}

    xpi = SX_dataset[i].xp = FMAKE_N(REAL, n,
                             "UL_EXTRACT_CURVE:xpi");
    ypi = SX_dataset[i].yp = FMAKE_N(REAL, n,
                             "UL_EXTRACT_CURVE:ypi");
    if (xpi == NULL || ypi == NULL)
       SS_error("INSUFFICIENT MEMORY - UL_EXTRACT_CURVE", SS_null);

/* interpolate the new curve from the old one */
    if ((xpj != NULL) && (ypj != NULL))
       {ymn = HUGE;
        ymx = -HUGE;

        for (k = 0, xv = xstart; k < n; k++, xv += xstep)
            {if (k == n - 1)
                xv = xstop;
             if ((k == 0) && (PM_CLOSETO_REL(xv, xpj[0])))
                {PM_interp(yv, xv, *xpj, *ypj, xpj[1], ypj[1]);}
             else
                {for (; xv > *xpj; xpj++, ypj++);
                 PM_interp(yv, xv, xpj[-1], ypj[-1], *xpj, *ypj);};

             ymn = min(ymn, yv);
             ymx = max(ymx, yv);

             *xpi++ = xv;
             *ypi++ = yv;};}

    if (irev)
       {xpi = SX_dataset[i].xp;
        ypi = SX_dataset[i].yp;

        for (l = 0; l < n/2; l++)
            {tmp = xpi[l];
             xpi[l] = xpi[n - l - 1];
             xpi[n - l - 1] = tmp;
             tmp = ypi[l];
             ypi[l] = ypi[n - l - 1];
             ypi[n - l - 1] = tmp;}

        SFREE(xpjtmp);
        SFREE(ypjtmp);}

    sprintf(s, "Extract %c (%e to %e by %e)",
            SX_dataset[j].id, xstart, xstop, xstep);

    SX_assign_next_id(i, (PFVoid) UL_plot);

    SX_dataset[i].text      = SC_strsavef(s, "char*:UL_EXTRACT_CURVE:text");
    SX_dataset[i].file      = NULL;
    SX_dataset[i].xmin      = xstart;
    SX_dataset[i].xmax      = xstop;
    SX_dataset[i].ymin      = ymn;
    SX_dataset[i].ymax      = ymx;
    SX_dataset[i].n         = n;
    SX_dataset[i].file_info = NULL;
    SX_dataset[i].file_type = NO_FILE;
    SX_dataset[i].modified  = FALSE;

    PG_set_line_info(SX_dataset[i].info, CARTESIAN, CARTESIAN, SOLID,
		     FALSE, 0, _SX_next_color(SX_graphics_device), 0, 0.0);

    return(SX_mk_curve_proc(i));}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* UL_XINDEX_CURVE - make a copy of the curve indexed by j
 *                 - with x values replaced by the index of the x values
 *                 - and return the objectified curve UL_label
 */

object *UL_xindex_curve(j)
   int j;
   {int i, k, n;
    REAL *xpi, *ypi, *xpj, *ypj;

    i = SX_next_space();
    n = SX_dataset[j].n;

    SX_assign_next_id(i, (PFVoid) UL_plot);

    SX_dataset[i].text      = SC_strsavef(SX_dataset[j].text,
                              "char*:UL_XINDEX_CURVE:text");
    SX_dataset[i].xmin      = 1.0;
    SX_dataset[i].xmax      = (double) n;
    SX_dataset[i].ymin      = SX_dataset[j].ymin;
    SX_dataset[i].ymax      = SX_dataset[j].ymax;
    SX_dataset[i].n         = n;
    SX_dataset[i].file_info = SX_dataset[j].file_info;
    SX_dataset[i].file_type = SX_dataset[j].file_type;
    SX_dataset[i].modified  = FALSE;

    if (SX_dataset[j].file != NULL)
       SX_dataset[i].file = SC_strsavef(SX_dataset[j].file,
                            "char*:UL_XINDEX_CURVE:file");
    else
       SX_dataset[i].file = NULL;

    xpj = SX_dataset[j].xp;
    ypj = SX_dataset[j].yp;
    xpi = SX_dataset[i].xp = FMAKE_N(REAL, n, "UL_XINDEX_CURVE:xpi");
    ypi = SX_dataset[i].yp = FMAKE_N(REAL, n, "UL_XINDEX_CURVE:ypi");
    if (xpi == NULL || ypi == NULL)
       SS_error("INSUFFICIENT MEMORY - UL_XINDEX_CURVE", SS_null);

/* copy data if it is already in memory */
    if ((xpj != NULL) && (ypj != NULL))
       for (k = 0; k < n; k++)
           {*xpi++ = (double) (k+1);
            *ypi++ = *ypj++;};

    PG_set_line_info(SX_dataset[i].info, CARTESIAN, CARTESIAN, SOLID,
		     FALSE, 0, _SX_next_color(SX_graphics_device), 0, 0.0);

    return(SX_mk_curve_proc(i));}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* UL_PRINT_BANNER - put the banner nicely on the screen */

void UL_print_banner()
   {SC_banner("");

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

