/*
 *  The Regina Rexx Interpreter
 *  Copyright (C) 1992-1994  Anders Christensen <anders@pvv.unit.no>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/****************************************************************************
*   This code modified for Multithread Win32 port by Les Moull April 1999.  *
****************************************************************************/

/*
 * $Id: rexx.h,v 1.7 1999/12/24 04:59:21 mark Exp $
 */

#if defined(HAVE_WINMULTITHREADING)
# include "configur.h"
# include "defs.h"
#endif

/* Things you might want to change .... (at your own risk!!!) */

/*
 * define NOFLISTS if you DON'T want to use the internal memory 
 * allocation functions.  By not using FLISTS, execution speed is reduced
 * by some 50%.  The use of NOFLISTS is useful for bounds checking
 * features of some compilers, but should be avoided for general use.
 *
 * It is available under Unix by using the --disable-flists switch
 * in autoconf script.
 * NOFLISTS can be be set on other ports by using FLISTS=N on the
 * 'make' command.
 */
#ifndef NOFLISTS
# define FLISTS
#endif

/*
 * define TRACEMEM to use tracing of dynamically allocated memory. This
 * is only useful when debugging memory management of the interpreter.
 * Some conditions must be fullfilled when using this (see memory.c).
 *
 * TRACEMEM is a subset of the debugging functionality. It is
 * available under Unix by using the --enable-tracemem switch
 * in autoconf script.
 * TRACEMEM can be be set on other ports by using TRACMEM=Y on the
 * 'make' command (you MUST also specify DEBUG=Y).
 */
#ifdef NDEBUG
# ifdef TRACEMEM
#  undef TRACEMEM
# endif
#endif


#ifdef CHECK_MEMORY                     /* Don't allow manual setting!       */
#  undef CHECK_MEMORY
#endif
#if defined(__GNUC__) && (defined(__BOUNDS_CHECKING_ON) || defined(__CHECKER__))
/*
 * Automatically define CHECK_MEMORY in case of GNU's bound checking
 * methods. Undef other memory checker settings since they are useless
 * in this case.
 */
#  define CHECK_MEMORY
#  ifdef FLISTS
#     undef FLISTS
#  endif
#  ifdef TRACEMEM
#     undef TRACEMEM
#  endif
#endif


/*
 * define PATTERN_MEMORY to initiate newly allocated dynamic memory to
 * a particular value, and freed memory to be set to another value
 * before it is freed. Useful for debugging only.
 */
#define PATTERN_MEMORY


extern char *numeric_forms[] ;
extern char *invo_strings[] ;


#if defined(__SASC)
# define REG_FAR __far
#else
# define REG_FAR
#endif

#if !defined(HAVE_WINMULTITHREADING)
# include "defs.h"
# if defined(HAVE_CONFIG_H)
#  include "config.h"
# endif
# include "configur.h"
#endif

#define MAXNUMERIC 64		/* Max setting for NUMERIC DIGITS 	*/
/* #define REXXDEBUG */		/* You probably don't want this ... :-) */

/* #define HAVE_STRMATH */	/* Do we have *real* REXX string math ? */
/* #define HAVE_MPMATH */	/* Do we have C ``mp'' math		*/
#define HAVE_CMATH		/* Do we have std. C math calls ? 	*/
#define MATH_TYPES 1		/* How many different types available	*/

#define LINELENGTH 1024         /* max linelength of source code        */
#define STACKSIZE 512		/* Was 256	*/
#define BUFFERSIZE 1024 /* Was 512 */ /* Size of input buffer, longest line   */
#define LOOKAHEAD 256           /* Size of input lookahead              */

#define SMALLSTR 5              /* For holding small integers		*/
#define NULL_STR_LENGTH 1
#define BOOL_STR_LENGTH 2

#define DEFAULT_TRACING		'N'
#define DEFAULT_INT_TRACING	0
#define DEFAULT_NUMFORM         NUM_FORM_SCI
#define DEFAULT_ENVIRONMENT 	ENV_SYSTEM
#define NESTEDCOMMENTS          /* The Standard wants them ....         */

#ifndef REXX_PATH_MAX
# ifndef PATH_MAX
#  ifndef _POSIX_PATH_MAX
#   ifndef _MAX_PATH
#    define REXX_PATH_MAX 1024
#   else
#    define REXX_PATH_MAX _MAX_PATH
#   endif
#  else
#   define REXX_PATH_MAX _POSIX_PATH_MAX
#  endif
# else
#  define REXX_PATH_MAX PATH_MAX
# endif
#endif

/* The following have been included to support national languages.       */
/*    English has a small set of letters. In the ASCII alphabet the      */
/*    English uppercase letters occupy the range from d2c(65) to d2c(90) */
/*    and the lowercase version of each letter have an offset of +32     */
/*    from the corresponding uppercase letter.                           */
/*                                                                       */
/* You may define FIRST_CHAR and LAST_CHAR to the lowermost and the      */
/*    uppermost letters of the uppercase alphabet. And you may define    */
/*    CHAR_OFFSET as the difference between upper- and lowercase.        */
/*    other Western European languages                                   */

#define FIRST_CHAR 	'A'
#define LAST_CHAR 	'Z'
#define CHAR_OFFSET	32

#define HEXNUM(c) (((c>='0')&&(c<='9'))||((c>='a')&&(c<='f')))
#define HEXVAL(c) (((c)>'9')?(RXTOLOW(c)-'a'+10):((c)-'0'))

#define PARSE_VERSION_STRING	"REXX-Regina_0_08h 4.80 24 Dec 1999"

#define TRUE 1
#define FALSE 0

/* Things you probably don't want to change ....			*/

#include <stdlib.h>
#include <stdio.h>
#ifdef VMS
# include <types.h>
#else
# include <sys/types.h>
#endif

#ifdef HAVE_SETJMP_H
# include <setjmp.h>
#endif

#include "strings.h"            /* definitions of REXX strings */
#include "types.h"		/* various types */
#include "extern.h"		/* function prototypes */

#define FREE_IF_DEFINED(a) { if (a) Free(a); a=NULL ; }

#ifdef VMS  /* F*ck DEC */
# ifdef EXIT_SUCCESS
#  undef EXIT_SUCCESS
# endif
# define EXIT_SUCCESS 1
#endif

/* For some mysterious reason, this macro is very difficult for some vendors */
#ifndef EXIT_SUCCESS
# define EXIT_SUCCESS 0
#endif

#define STRIP_TRAILING   1
#define STRIP_LEADING    2
#define STRIP_BOTH       (STRIP_TRAILING|STRIP_LEADING)

REG_FAR extern lineboxptr first_source_line, last_source_line ;
extern FILE *stddump ;
extern nodeptr parseroot ;
extern char *signalnames[] ;
extern sigtype signals ;
extern sigtype *nextsig ;
extern streng nofunc ;
     
extern int parse_error_flag ;
extern proclevel currlevel, mainlevel ;
extern sysinfo systeminfo ;
#if defined(HAVE_WINMULTITHREADING)
int __stdcall InitG3(void);
globalext *Common(void);
#endif

