(define (get-char-metrics (afm <afm>) (string <string>))
  (map (lambda (ch)
         (table-lookup (code-metrics afm) ch))
       (string->list string)))

(define (string-x-deltas (afm <afm>) (str <string>))
  (let loop ((r '())
             (i 1))
    (if (< i (string-length str))
        (let* (((cm1 <char-metrics>) (table-lookup (code-metrics afm)
                                                   (string-ref str (- i 1))))
               ((cm2 <char-metrics>) (table-lookup (code-metrics afm)
                                                   (string-ref str i)))
               (ki (vassq cm2 (kern-follows cm1))))
          (loop (cons
                 (if ki
                     (/ (vector-ref (kern-follows cm1) ki) 1000)
                     0)
                 r)
                (+ i 1)))
        (reverse r))))

(define-method string-width ((afm <afm>) (font-size <real>) (str <string>))
  (* (/ font-size 1000)
     (reduce + 0 (map x-width (get-char-metrics afm str)))))

;; `xshow-x-list' returns a list of the x shifts to use in
;; the `xshow' postscript operator to implement kerning.

(define-method xshow-x-list ((afm <afm>) (font-size <real>) (str <string>))
  (let ((dx (append (string-x-deltas afm str) '(0)))
        (x (map x-width (get-char-metrics afm str))))
    (map (curry * (/ font-size 1000)) (map + x dx))))
