
(define (draw-grid-points (in <open-view>))
  ;; compute the user-space bbox
  (bind (((v <view>) (underlying-object in))
	 (ictm (invert-transform (view-ctm v)))
	 (ctm (invert-transform (translate ictm (view-origin v))))
	 ((bb <rect>) (transform (make-rect (x (view-origin v))
					    (y (view-origin v))
					    (width (view-frame v))
					    (height (view-frame v)))
				 ictm))
	 (min-x min-y num-x num-y spacing (spacing-to-draw bb))
	 (lst '()))
    (dm "grid bbox (user space): ~s (~d x ~d array)" bb num-x num-y)
    (let y-loop ((iy 0) 
		 (gy min-y))
      (if (< iy num-y)
	  (let x-loop ((ix 0) 
		       (gx min-x))
	    (if (< ix num-x)
		(let ((p (device-point (transform (make-point gx gy) ctm))))
		  (set! lst (cons* (x p) (y p) lst))
		  (x-loop (+ ix 1) (+ gx spacing)))
		(y-loop (+ iy 1) (+ gy spacing))))
	  (draw-points (content-window in) 
		       (grid-gcontext in)
		       lst)))))

(define (spacing-to-draw (bb <rect>))
  (let ((user-grid-spacing 10))
    (let loop ((grid-spacing-mult '(1 2 5 10 25 50 100)))
      (let* ((grid-spacing (* user-grid-spacing (car grid-spacing-mult)))
	     (min-x (* grid-spacing (floor (/ (origin-x bb) grid-spacing))))
	     (x-pts (inexact->exact
		     (ceiling (/ (- (limit-x bb) min-x) grid-spacing))))
	     (min-y (* grid-spacing (floor (/ (origin-y bb) grid-spacing))))
	     (y-pts (inexact->exact
		     (ceiling (/ (- (limit-y bb) min-y) grid-spacing)))))
	(if (or (> x-pts 100) (> y-pts 100))
	    (loop (if (pair? (cdr grid-spacing-mult))
		      (cdr grid-spacing-mult)
		      (list (* 2 (car grid-spacing-mult)))))
	    (values min-x min-y x-pts y-pts grid-spacing))))))

(define (t)
  (for-each
   draw-grid-points
   (open-views (current-client))))
