

(define (selection-tool-button-press (in-view <open-view>)
				     (at <point>) ;; window device coords
				     modifier-state)
  (bind ((at (window->sheet in-view at))
	 (h h-at (table-lookup (current-handles in-view) at)))
    (dm "at ~s, h => ~s @ ~s" at h h-at)
    (if h
	; clicked in an active handle...
	(set-active-drag-proc!
	 in-view
	 (start-active-drag-handle (car h) in-view (cdr h) h-at))
	; clicked elsewhere...
	(let ((lst (pick-list in-view at)))
	  ; cancel any currently active drag
	  (set-active-drag-proc! in-view #f)
	  ;
	  (if (pair? lst)
	      (let ((item (do-select in-view (cdar lst) modifier-state)))
		; start an active drag
		(set-active-drag-proc! in-view
				       (start-active-drag 
					item
					in-view
					(tweak-point in-view at))))
	      (begin
		(clear-current-selection! in-view)
		(set-status-line! in-view "")))
	  (update-handles in-view)
	  (clear-area (content-window in-view))
	  (redraw-open-view in-view)))))

(define (do-select (in-view <open-view>) (item <graphic-object>) mstate)
  (set-status-line! in-view (status-line-when-sel item))
  (if (not (shift-state? mstate))
      (clear-current-selection! in-view))
  (add-to-current-selection! in-view item)
  item)

(add-major-mode!
 (make <major-mode>
       name: 'select
       button-press-proc: selection-tool-button-press))
