--          This file is part of SmallEiffel The GNU Eiffel Compiler.
--          Copyright (C) 1994-98 LORIA - UHP - CRIN - INRIA - FRANCE
--            Dominique COLNET and Suzanne COLLIN - colnet@loria.fr
--                       http://SmallEiffel.loria.fr
-- SmallEiffel is  free  software;  you can  redistribute it and/or modify it
-- under the terms of the GNU General Public License as published by the Free
-- Software  Foundation;  either  version  2, or (at your option)  any  later
-- version. SmallEiffel is distributed in the hope that it will be useful,but
-- WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
-- or  FITNESS FOR A PARTICULAR PURPOSE.   See the GNU General Public License
-- for  more  details.  You  should  have  received a copy of the GNU General
-- Public  License  along  with  SmallEiffel;  see the file COPYING.  If not,
-- write to the  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
-- Boston, MA 02111-1307, USA.
--
class FUNCTION

inherit EFFECTIVE_ROUTINE;

creation make

feature

   result_type: TYPE;

feature

   make(n: like names;
        fa: like arguments; t: like result_type;
        om: like obsolete_mark;
        hc: like header_comment;
        ra: like require_assertion; lv: like local_vars;
        rb: like routine_body) is
      require
         t /= void
      do
         make_effective_routine(n,fa,om,hc,ra,lv,rb);
         result_type := t;
      end;

   to_run_feature(t: TYPE; fn: FEATURE_NAME): RUN_FEATURE_4 is
      do
         !!Result.make(t,fn,Current);
      end;

feature {C_PRETTY_PRINTER}

   stupid_switch(up_rf: RUN_FEATURE; r: ARRAY[RUN_CLASS]): BOOLEAN is
      local
         rf8a, rf8b: RUN_FEATURE_8;
         rf4a, rf4b: RUN_FEATURE_4;
         rf2a, rf2b: RUN_FEATURE_2;
         rfa, rfb: RUN_FEATURE;
         offseta, offsetb: INTEGER;
         calla, callb: CALL;
         call0a, call0b: CALL;
         rta, rtb: TYPE;
         i: INTEGER;
         rc: RUN_CLASS;
      do
         rf4a ?= r.first.dynamic(up_rf);
         if rf4a.is_empty_or_null_body then
            Result := not up_rf.result_type.is_anchored;
            if Result then
               cpp.put_comment("SSF1");
            end;
         end;
         if not Result then
            from
               Result := true;
               i := r.upper;
            until
               not Result or else i = 0
            loop
               rc := r.item(i);
               rf4b ?= rc.dynamic(up_rf);
               rf2b := rf4b.is_attribute_reader;
               if rf2a = Void then
                  rf2a := rf2b;
                  if rf2a /= Void then
                     offseta := rc.offset_of(rf2a);
                  end;
               end;
               if rf2b = Void then
                  Result := false;
               elseif rf2a.name.to_string = rf2b.name.to_string then
                  offsetb := rc.offset_of(rf2b);
                  Result := offseta = offsetb;
               else
                  Result := false;
               end;
               i := i - 1;
            end;
            if Result then
               cpp.put_comment("SSF2");
            end;
         end;
         if not Result then
            from
               Result := true;
               i := r.upper;
            until
               not Result or else i = 0
            loop
               rc := r.item(i);
               rf4b ?= rc.dynamic(up_rf);
               callb := rf4b.is_direct_call_on_attribute;
               if callb /= Void then
                  rfb := callb.run_feature;
                  call0b ?= callb.target;
                  rf2b ?= call0b.run_feature;
                  offsetb := rc.offset_of(rf2b);
                  rf8b ?= rfb;
               end;
               if calla = Void then
                  calla := callb;
                  rfa := rfb;
                  call0a := call0b;
                  rf2a := rf2b;
                  offseta := offsetb;
                  rf8a := rf8b;
               end;
               if callb = Void then
                  Result := false;
               elseif offseta /= offsetb then
                  Result := false;
               elseif rfa = rfb then
               elseif rf8a /= Void and then rf8b /= Void then
                  if rf8a.name.to_string = as_item then
                     rta := rf8a.result_type;
                     rtb := rf8b.result_type;
                     if rta.is_reference then
                        Result := rtb.is_reference;
                     else
                        Result := rta.run_time_mark = rtb.run_time_mark;
                     end;
                  end;
               else
                  Result := false;
               end;
               i := i - 1;
            end;
            if Result then
               cpp.put_comment("SSF3");
            end;
         end;
         if not Result then
            Result := stupid_switch_for_collection(up_rf,r);
            if Result then
               cpp.put_comment("SSF4");
            end;
         end;
      end;

feature {NONE}

   stupid_switch_for_collection(up_rf: RUN_FEATURE; r: ARRAY[RUN_CLASS]): BOOLEAN is
         -- I think it is a little bit dirty to handle these features
         -- specifically.
      local
         bcn: STRING;
         fns: STRING;
         i: INTEGER;
         rf: RUN_FEATURE;
      do
         bcn := up_rf.current_type.base_class.name.to_string;
         if as_array = bcn or else as_fixed_array = bcn then
            fns := up_rf.name.to_string;
            if collection_names.fast_has(fns) then
               from
                  i := r.upper;
                  Result := true;
               until
                  not Result or else i = 0
               loop
                  rf := r.item(i).dynamic(up_rf);
                  if rf.result_type.is_expanded then
                     Result := false;
                  end;
                  i := i - 1;
               end;
            end
            if not Result then
               if fns = as_lower then
                  Result := true;
               elseif fns = as_upper then
                  Result := true;
               elseif fns = as_count then
                  Result := true;
               elseif fns.is_equal("empty") then
                  Result := true;
               end;
            end;
         end;
      end;

   collection_names: ARRAY[STRING] is
      once
         Result := <<as_item, as_at, as_first, as_last>>;
      end;

   try_to_undefine_aux(fn: FEATURE_NAME;
                       bc: BASE_CLASS): DEFERRED_ROUTINE is
      do
         !DEFERRED_FUNCTION!Result.from_effective(fn,arguments,
                                                  result_type,
                                                  require_assertion,
                                                  ensure_assertion,
                                                  bc);
      end;

   pretty_print_once_or_do is
      do
         fmt.keyword(fz_do);
      end;

end -- FUNCTION

