/* Interface to TLLSubroutine: TLL C messaging.
   This file is part of TL, Tiggr's Library.
   Written by Tiggr <tiggr@es.ele.tue.nl>
   Copyright (C) 1995, 1996 Pieter J. Schoenmakers
   TL is distributed WITHOUT ANY WARRANTY.
   See the file LICENSE in the TL distribution for details.

   $Id: TLLSubroutine.h,v 1.1 1998/01/08 16:13:24 tiggr Exp $  */

#import "TLSymbol.h"
#import "support.h"
#if HAVE_STRINGS_H
#import "strings.h"
#endif

/* Special values for max_args of a subroutine.  */
enum
{
  ARGS_UNEVAL = -2,
  ARGS_NUM_ANY,
};

/* The kind of function a subroutine can stand for.  */
typedef id (*tll_subroutine) ();

/* Definition of a subroutine, as passed to `+registerSubroutines:'.  */
struct tl_subdef
{
  /* Iff !0, assign the symbol created for this subroutine to the value
     being pointed to.  */
  TLSymbol **sym;

  /* Symbol's name.  */
  id name;

  /* The function.  */
  tll_subroutine fun;

  /* Min and max arguments.  */
  int min, max;
};

/* Nice 'n easy struct filling.  */
#define DEFSUB(S, N, F, MIN, MAX)  {(TLSymbol **) S, N, F, MIN, MAX}

#if SUPPORT_DEBUG
/* Information maintained on the invocation of a method (from TLisp),
   a (named) TLisp function or a (anonymous) lambda.  */
typedef struct tll_invocation_info
{
  /* If -2, this invocation has been created by a symbol but has not yet
     been filled.  If it is -1, the arguments to the invocation are being
     computer.  If it is 0, ARGL is the argument list.  If it is positive,
     ARGV points to an array holding the indicated number of arguments.  */
  int argc;

  /* For a method invocation, this is the receiver.  Otherwise, this is nil.  */
  id receiver;

  /* For a method invocation, this is the selector symbol.  For a function
     invocation, it is the (a) function symbol.  For the invocation of an
     anonymous lambda, this is NIL.  */
  TLSymbol *name;

  /* The arguments to the invocation if it is a list.  */
  TLCons *argl;

  /* The arguments to the invocation, as an array.  */
  id *argv;
} tll_invocation_info;

/* The invocation registration information stack, the number of entries and
   the stack's current capacity.  */
extern tll_invocation_info *tll_invocation_stack;
extern int tll_invocation_num, tll_invocation_cap;

/* XXX */
typedef int invocation_stack_level;

/* Limit on the invocation stack.  */
extern int max_lisp_eval_depth;

__TL_INLINE__ int
tll_invocation_new (void)
{
  if (tll_invocation_num == max_lisp_eval_depth)
    [TLObject error: "max-lisp-eval-depth (%d) exceeded",
     max_lisp_eval_depth];
  if (tll_invocation_num == tll_invocation_cap)
    {
      tll_invocation_cap += 32;
      tll_invocation_stack
	= xrealloc (tll_invocation_stack,
		    tll_invocation_cap * sizeof (*tll_invocation_stack));
      bzero ((void *) (tll_invocation_stack + (tll_invocation_cap - 32)),
	     32 * sizeof (*tll_invocation_stack));
    }
  return (tll_invocation_num++);
} /* tll_invocation_new */

__TL_INLINE__ void
tll_invocation_pop (int level)
{
  tll_invocation_num = level;
} /* tll_invocation_pop */
#endif

/* External declarations (see definitions for comments).  */
id tll_invoke_method (id receiver, TLSymbol *selector,
		      id *argv, int num_args, int eval);

@interface TLLSubroutine: TLObject
{
  /* C function to invoke.  */
  tll_subroutine fun;

  /* Arguments.  */
  int min_args, max_args;

  /* Documentation.  */
  id <TLString> documentation;
}

/* Register the zero-NAME terminated array of subroutine definitions.  */
+(void) registerSubroutines: (struct tl_subdef *) defs;

+(TLLSubroutine *) subroutineWithFunction: (tll_subroutine) f
 args: (int) min_args : (int) max_args;

-initWithFunction: (tll_subroutine) f args: (int) min_args : (int) max_args;

-evalWithArguments: (TLCons *) args;

-setDocumentation: (id <TLString>) doc;
-(id <TLString>) documentation;

@end
