/* Interface to TLSymbol class.
   This file is part of TL, Tiggr's Library.
   Written by Tiggr <tiggr@es.ele.tue.nl>
   Copyright (C) 1995, 1996 Pieter J. Schoenmakers
   TL is distributed WITHOUT ANY WARRANTY.
   See the file LICENSE in the TL distribution for details.

   $Id: TLSymbol.h,v 1.2 1999/09/30 18:14:59 tiggr Exp $  */

#import "TLString.h"

@class TLSymbol, TLCons;

/* Predefined symbols.  */
extern TLSymbol *Qnil, *Qt;
extern TLSymbol *Qtll_class_list, *Qobjc_class_list;

/* Predefined streams.  */
extern TLSymbol *Q_stdin_, *Q_stdout_, *Q_stderr_;

/* For use in a debugger.  */
TLSymbol *symbol (const char *name);

/* The type returned by value pushing.  */
typedef int binding_stack_level;

/* The kind of function values.  */
enum function_value_type
{
  FVT_UNSET,
  FVT_AUTOLOAD,
  FVT_FUNCTION,
};

/* The kind of variable values.  */
enum variable_value_type
{
  VVT_UNSET,
  VVT_OBJECT,
  VVT_OBJC_CLASS,
  VVT_ENCODED_C,
};

/* Predefine a symbol named SYM whose C value is stored in VAR.  */
#define TLSYMBOL_PREDEFINE(SYM, VAR)  \
  [[TLSymbol symbolWithName: (SYM)]	\
   setCValue: &(VAR) encoding: @encode (__typeof__ (VAR))]

@interface TLSymbol: TLObject
{
  /* The textual name of this symbol.  */
  id <TLString> name;

  /* The value as a variable of this symbol.  Interpretation depends on
     the value of VVT.  If VVT is VVT_OBJECT, this is a simple object.  If
     VVT is VVT_ENCODED_C, it points to the encapsulated C value.  */
  id var_value;

  /* The value as a function of this symbol.  Actual kind is defined by FVT.  */
  void *fun_value;

  /* The list of properties of this symbol.  */
  id properties;

  /* If VVT is VVT_ENCODED_C, this is the @encode for the type pointed to
     by VAR_VALUE.  */
  int extra;

  /* Selector information.  If this symbol denotes a selector, SELECTOR is
     the actual selector and num_args is the number of arguments to the
     selector.  */
  SEL selector;
  int sel_num_args;

  /* Iff set, this symbol is read-only.  */
  unsigned int ro_var: 1, ro_fun: 1, :6;

  /* The type of fun_value.  */
#if 0
  /* GNU CC 2.95.1 chokes on this.  */
  enum function_value_type fvt: 4;
  enum variable_value_type vvt: 4;
#endif
  unsigned int fvt: 4, vvt: 4;
}

+(TLSymbol *) symbolWithName: (id <TLString>) name;
+(TLSymbol *) symbolWithName: (id <TLString>) name funValue: f;
+(TLSymbol *) symbolWithName: (id <TLString>) name varValue: v;
+(TLSymbol *) symbolWithName: (id <TLString>) name constantValue: v;

-autoload: (id <TLString>) file;

-eval;
-evalWithArguments: (TLCons *) args;

-fboundp;
-funValue;

-initWithName: (id <TLString>) name;

-(id <TLString>) symbolName;
-setName: (id <TLString>) new_name;

/* Tell the symbol it is an Objective-C class.  */
-setIsObjcClass: (struct objc_class *) class;

/* Tell the symbol its variable value is a selector with NUM_ARGS
   arguments (besides the implicit return value, SELF and _CMD).  */
-setIsSelector: (int) num_args;

-(void) setVarValue: v;
-set: v;
-setVarReadOnly: ynp;
-setFunReadOnly: ynp;
-(void) setFunValue: f;
-fset: v;

-makunbound;
-varValue;

-(void) setCValue: (void *) address encoding: (char *) encoding;

/******************** selectors ********************/

-mboundp;
-(int) selNumArguments;
-(SEL) selSelector;

/******************** properties ********************/

-get: property;

-(TLCons *) propertyList;

-put: property : value;

/******************** variable binding ********************/

+(binding_stack_level) bindingLevel;

/* Pop all variable value up to the bindings stack value of LEVEL.  */
+(void) popVarValues: (binding_stack_level) level;

/* Push the A_VALUE as the variable value for this symbol and return the
   previous binding stack.  */
-(binding_stack_level) pushVarValue: a_value;

@end
