/*
   Written by Pieter J. Schoenmakers <tiggr@ics.ele.tue.nl>

   Copyright (C) 1996 Pieter J. Schoenmakers.

   This file is part of TOM.  TOM is distributed under the terms of the
   TOM License, a copy of which can be found in the TOM distribution; see
   the file LICENSE.

   $Id: OTMEntity.m,v 1.13 1998/01/05 01:12:46 tiggr Exp $  */

#import "OTMEntity.h"

@implementation OTMEntity

-(void) description: (id <TLMutableStream>) stream
{
  formac (stream, @" %@:%d %@", filename, line_number, name);
}

-(void) gcReference
{
  MARK (name);
  [super gcReference];
}

-initWithName: (TLString *) n
{
  [super init];

  name = n;

  return self;
}

-(id <TLString>) typeName
{
  return name;
}

-(id <TLString>) outputTypeName
{
  return name;
}

@end
