/*
   Written by Pieter J. Schoenmakers <tiggr@ics.ele.tue.nl>

   Copyright (C) 1996 Pieter J. Schoenmakers.

   This file is part of TOM.  TOM is distributed under the terms of the
   TOM License, a copy of which can be found in the TOM distribution; see
   the file LICENSE.

   $Id: OTMNumberCST.m,v 1.7 1998/01/05 01:13:31 tiggr Exp $  */

#define OTMNUMBERCST_DECLARE_PRIVATE_METHODS
#import "OTMNumberCST.h"
#import "OTMBasic.h"

@implementation OTMNumberCST

+(OTMNumberCST *) numberWithValue: (id <TLString>) v type: (OTMType *) t
{
  return [[self gcAlloc] initWithValue: v type: t];
}

-(void) description: (id <TLMutableStream>) stream
{
  [super description: stream];

  formac (stream, @" %@", value);
}

-(void) gcReference
{
  MARK (value);

  [super gcReference];
}

-(id) initWithValue: (id) v type: (OTMType *) t
{
  if (![super initWithType: t])
    return nil;

  value = v;

  return self;
}

-(id <TLString>) result
{
  return [self outputValue];
}

-(id <TLString>) outputValue
{
  if (type == basic_type[BT_LONG])
    return formac (nil, @"%@LL", value);
  return value;
}

@end
