/*
   Written by Pieter J. Schoenmakers <tiggr@ics.ele.tue.nl>

   Copyright (C) 1996 Pieter J. Schoenmakers.

   This file is part of TOM.  TOM is distributed under the terms of the
   TOM License, a copy of which can be found in the TOM distribution; see
   the file LICENSE.

   $Id: OTMObjectVar.m,v 1.30 1998/01/05 01:13:34 tiggr Exp $  */

#define OTMOBJECTVAR_DECLARE_PRIVATE_METHODS
#import "OTMObjectVar.h"
#import "OTMCustomMethod.h"
#import "OTMExtension.h"
#import "OTMType.h"
#import "LTTPatches.h"
#import "global.h"

@implementation OTMObjectVar

+(OTMObjectVar *) variableWithExtension: (OTMExtension *) e
				   name: (TLString *) n
				   type: (OTMType *) t
			     qualifiers: (otm_qualifiers) q
{
  return [[self gcAlloc] initWithExtension: e name: n type: t qualifiers: q];
}

-(void) compileAssignment: (OTMExpr *) rhs
{
  /* XXX This used to include a `|| STACK_PROTECT == SP_MARK', but I'm not
     sure if that is correct, or was simply here because of the copy-paste
     from OTMLocalVar.m...  Fri Apr 5 01:57:08 1996, --Tiggr.  */
  if (flag_atomic_gc || ![type isObjectType] || [self staticp])
    [super compileAssignment: rhs];
  else
    {
      BOOL self_class_p = [[[ext structure] meta] classp];
      BOOL current_class_p = [output_current_context classp];
      id <TLString> tom_state_name
	= current_class_p ? tom_c_state_field_name : tom_i_state_field_name;
      id foo;

      if (!current_class_p && self_class_p)
	foo = formac (nil, @"%@->%@.%@", TO_NAME_SELF, tom_state_name,
		      TO_NAME_ISA);
      else
	foo = formac (nil, @"%@", TO_NAME_SELF);

      formac (of, @"%@%@ = %@ (%@, %@);", [self nl], [self outputReference],
	      TO_TRT_ASSIGN_OBJECT_VAR, foo, [rhs result]);
    }
}

-(void) compileDeclaration
{
  if (![self staticp])
    ABORT ();

  if (th_local)
    formac (of, @"extern int _tlo_%@;\n", [self outputName]);
  else
    formac (of, @"extern %@ %@;\n", [type outputTypeName], [self outputName]);
}

-(void) dumpInfo: (id <TLOutputStream>) s
{
  if ([self staticp])
    formac (s, @"\n  (%# %@ (%@%#))", name,
	    [[type actualSelf: [output_current_context semantics]] typeInfo],
	    th_local ? @"local " : @"static ", [self outputName]);
  else
    {
      LTTMeta *m = [[ext structure] meta];

      if (![m classp] && !(m == ltt_instance_state
			   || [ltt_instance_state isProperSub: m]))
	error_for (self, @"instance variable `%@' in stateless %@",
		   name, ltt_meta_name (m));

      formac (s, @"\n  (%# %@)", name,
	      [[type actualSelf: [output_current_context semantics]] typeInfo]);
    }
}

-(OTMExtension *) extension
{
  return ext;
}

-(void) gcReference
{
  MARK (ext);

  [super gcReference];
}

-(id) initWithExtension: (OTMExtension *) e
		   name: (TLString *) n
		   type: (OTMType *) t
	     qualifiers: (otm_qualifiers) q
{
  if (![super initWithName: n type: t])
    return nil;

  qualifiers = q;
  ext = e;

  /* XXX Check nonsensical qualifiers.  */

  if (!Q_PROTECTION (q))
    q = Q_SET_PROTECTION (q, OQ_PROTECTED);

  [self setQualifiers: q];

  return self;
}

-(BOOL) isThreadLocal
{
  return th_local;
}

-(id <TLString>) result
{
  return [self outputReference];
}

-(id <TLString>) outputName
{
  if (![self staticp])
    return [super outputName];

  return formac (nil, @"%@_%@", [[ext structure] outputName],
		 [super outputName]);
}

-(id) outputReference
{
  LTTExtension *x = [ext structure];
  id s = nil;

  if ([self staticp])
    {
      if (th_local)
	return formac (nil, @"*(%@ *) (_th_locals + _tlo_%@)",
		       [type outputTypeName], [self outputName]);
      else
	return [self outputName];
    }
  else
    {
#if CACHE_EXTENSION_POINTER
      s = formac (s, @"%@%@", TO_EXT_POINTER_PREFIX, [x outputName]);
#else /* !CACHE_EXTENSION_POINTER */
      s = formac (s, @"(%@)", [ext outputOffsetFrom: output_current_context]);
#endif

      return formac (s, @"->%@", [self outputName]);
    }
}

-(id) precompile
{
  [ext compileDeclareExtensionIdentityName];

  [[[[ext structure] meta] semantics] precompile];

#if CACHE_EXTENSION_POINTER
  if (current_method && ![self staticp])
    [current_method declareExtensionPointer: ext];
#endif

  if (th_local && current_method)
    [current_method setNeedLocalPointer];

  return [super precompile];
}

-(void) setIsThreadLocal
{
  th_local = 1;
}

@end
