/****************************************************************************
|                         Digital Audio Processor
|                         =======================
|
| Filename    : stdrever.cc
|
| Revision    : 1.1
| Date        : 25/01/96
|
| Object      : DSPKitStdReverb
|
| Description : DSPKitStdReverb
|
| (c) Richard Kent 1996
|
| $Id$
|
****************************************************************************/

static char stdrever_cc [] = "$Id$";

#include "stdrever.h"

long DSPKitStdReverb::setInput (DSPKitProcessor *ip)
{
  return setInput (ip,1.0,1.0);
}

long DSPKitStdReverb::setInput
  (DSPKitProcessor *ip,double size,double spread)
{
  mux.setInput (ip);

  comb1.setInputAndDelayTime (&mux,0.050 * size);
  comb1.setG (0.83);
  comb1.setG1 (0.24);

  comb2.setInputAndDelayTime (&mux,0.056 * size);
  comb2.setG (0.83);
  comb2.setG1 (0.26);

  comb3.setInputAndDelayTime (&mux,0.061 * size);
  comb2.setG (0.83);
  comb3.setG1 (0.28);

  comb4.setInputAndDelayTime (&mux,0.068 * size);
  comb4.setG (0.83);
  comb4.setG1 (0.29);

  comb5.setInputAndDelayTime (&mux,0.072 * size);
  comb5.setG (0.83);
  comb5.setG1 (0.30);

  comb6.setInputAndDelayTime (&mux,0.078 * size);
  comb6.setG (0.83);
  comb6.setG1 (0.32);

  sum.setInput (&comb1);
  sum.addInput (&comb2);
  sum.addInput (&comb3);
  sum.addInput (&comb4);
  sum.addInput (&comb5);
  sum.addInput (&comb6);

  amp.setInput (&sum);
  amp.setGain (1.0 / 6.0);

  allpass.setInputAndDelayTime (&amp,0.006 * spread);
  allpass.setG (0.7);

  return DSPKitProcessor::setInput (&allpass);
}

void DSPKitStdReverb::setReverbTime (double rt)
{
  reverbTime = rt;
  comb1.setReverbTime (reverbTime);
  comb2.setReverbTime (reverbTime);
  comb3.setReverbTime (reverbTime);
  comb4.setReverbTime (reverbTime);
  comb5.setReverbTime (reverbTime);
  comb6.setReverbTime (reverbTime);
}

void DSPKitStdReverb::setG (double newG)
{
  comb1.setG (newG);
  comb2.setG (newG);
  comb3.setG (newG);
  comb4.setG (newG);
  comb5.setG (newG);
  comb6.setG (newG);
}

/***************************************************************************/
