#   include	"config.h"

#   include	"bmintern.h"
#   include	<debugon.h>

/************************************************************************/
/*  Replace 'White' in a bitmap with 'Transparent'			*/
/************************************************************************/
static unsigned char	firstBytes[256];
static unsigned char	secondBytes[256];

int bmWhiteToTransparent(	BitmapDescription *		bdOut,
				const BitmapDescription *	bdIn,
				unsigned char **		pBufOut,
				const unsigned char *		bufIn,
				int				ignoredInt )
    {
    BitmapDescription		bd= *bdIn;
    unsigned char *		bufOut;
    int				row, col;
    const unsigned char *	from;
    unsigned char *		to;

    switch( bdIn->bdColorEncoding )
	{
	case BMcoBLACKWHITE:
	    if  ( bdIn->bdSamplesPerPixel != 1 )
		{ LDEB(bdIn->bdSamplesPerPixel); return -1;	}
	    bd.bdSamplesPerPixel= 2;
	    bd.bdHasAlpha= 1;

	    switch( bdIn->bdBitsPerSample )
		{
		case 1:
		    for ( row= 0; row < 256; row++ )
			{
			firstBytes[row]=	(  row & 0x80 )     	|
						( ~row & 0x80 ) >> 1	|
						(  row & 0x40 ) >> 1	|
						( ~row & 0x40 ) >> 2	|
						(  row & 0x20 ) >> 2	|
						( ~row & 0x20 ) >> 3	|
						(  row & 0x10 ) >> 3	|
						( ~row & 0x10 ) >> 4	;

			secondBytes[row]=	(  row & 0x08 ) << 4	|
						( ~row & 0x08 ) << 3	|
						(  row & 0x04 ) << 3	|
						( ~row & 0x04 ) << 2	|
						(  row & 0x02 ) << 2	|
						( ~row & 0x02 ) << 1	|
						(  row & 0x01 ) << 1	|
						( ~row & 0x01 )     	;
			}
		    break;
		case 2:
		    for ( row= 0; row < 256; row++ )
			{
			firstBytes[row]=	(  row & 0xc0 )     	|
						( ~row & 0xc0 ) >> 2	|
						(  row & 0x60 ) >> 2	|
						( ~row & 0x60 ) >> 4	;

			secondBytes[row]=	(  row & 0x0c ) << 4	|
						( ~row & 0x0c ) << 2	|
						(  row & 0x06 ) << 2	|
						( ~row & 0x06 )     	;
			}
		case 4:
		    for ( row= 0; row < 256; row++ )
			{
			firstBytes[row]=	(  row & 0xf0 )     	|
						( ~row & 0xf0 ) >> 4	;

			secondBytes[row]=	(  row & 0x0f ) << 4	|
						( ~row & 0x0f )     	;
			}
		    break;
		case 8:
		    for ( row= 0; row < 256; row++ )
			{
			firstBytes[row]=	 row;
			secondBytes[row]=	~row;
			}
		    break;
		default:
		    LDEB(bdIn->bdBitsPerSample); return -1;
		    break;
		}
	    break;
	case BMcoWHITEBLACK:
	    if  ( bdIn->bdSamplesPerPixel != 1 )
		{ LDEB(bdIn->bdSamplesPerPixel); return -1;	}
	    bd.bdSamplesPerPixel= 2;
	    bd.bdHasAlpha= 1;
	    break;
	case BMcoRGB:
	    if  ( bdIn->bdSamplesPerPixel != 3 )
		{ LDEB(bdIn->bdSamplesPerPixel); return -1;	}
	    bd.bdSamplesPerPixel= 4;
	    bd.bdHasAlpha= 1;
	    break;
	default:
	    LDEB(bdIn->bdColorEncoding); return -1;
	}

    bd.bdBitsPerPixel= bd.bdSamplesPerPixel* bd.bdBitsPerSample;
    bd.bdBytesPerRow= ( bd.bdPixelsWide* bd.bdBitsPerPixel+ 7 )/8;
    bd.bdBufferLength= bd.bdBytesPerRow* bd.bdPixelsHigh;
    bufOut= malloc( bd.bdBufferLength );
    if  ( ! bufOut )
	{ LLDEB(bd.bdBufferLength,bufOut); return -1;	}

    switch( bdIn->bdColorEncoding )
	{
	case BMcoBLACKWHITE:
	    switch( bdIn->bdBitsPerSample )
		{
		case 1: case 2: case 4: case 8:
		    for ( row= 0; row < bdIn->bdPixelsHigh; row++ )
			{
			from= bufIn + row* bdIn->bdBytesPerRow;
			to  = bufOut+ row* bd.   bdBytesPerRow;

			for ( col= 0; col < bdIn->bdBytesPerRow; col++ )
			    {
			    *(to++)=	firstBytes[*from];
			    *(to++)=	secondBytes[*from];
			    from++;
			    }
			}
		    break;
		default:
		    LDEB(bdIn->bdBitsPerSample); return -1;
		}
	    break;
	case BMcoWHITEBLACK:
	    switch( bdIn->bdBitsPerSample )
		{
		case 1: case 2: case 4: case 8:
		    for ( row= 0; row < bdIn->bdPixelsHigh; row++ )
			{
			from= bufIn + row* bdIn->bdBytesPerRow;
			to  = bufOut+ row* bd.   bdBytesPerRow;

			for ( col= 0; col < bdIn->bdBytesPerRow; col++ )
			    {
			    *(to++)=	firstBytes[*from];
			    *(to++)=	secondBytes[*from];
			    from++;
			    }
			}
		    break;
		default:
		    LDEB(bdIn->bdBitsPerSample); return -1;
		}
	    break;
	case BMcoRGB:
	    LDEB(bdIn->bdColorEncoding); return -1;
	    break;
	default:
	    LDEB(bdIn->bdColorEncoding); return -1;
	}

    *bdOut= bd; *pBufOut= bufOut;

    return 0;
    }
