%option c++
%{
#include "UParser.h"
#include <stdio.h>
#include <string.h>
#define MY ((UParser*) this)->
#define UMwrap() 1

#if HAVE_STRTOL==0
#error This function needs strtol.
#endif

/*
#define YYLMAX 1024
*/

int	lineNumber=1;
%}
D                       ([0-9])
L                       ([a-zA-Z_])
H                       ([a-fA-F0-9])
E                       ([Ee][+-]?{D}+)

WORD			{L}({L}|{D})*

HEX_INT                 ([-+]?0[xX]{H}+)
OCT_INT                 ([-+]?0{D}+)
DEC_INT                 ([-+]?{D}+)
INT                     ({HEX_INT}|{OCT_INT}|{DEC_INT})

REAL_1                  ([-+]?{D}+{E})
REAL_2                  ([-+]?{D}*"."{D}+{E}?)
REAL_3                  ([-+]?{D}+"."{D}*{E}?)
REAL                    ({REAL_1}|{REAL_2}|{REAL_3})
%x COMMENT IGNORE ESC
%%
"\\"		{ BEGIN (ESC); }
<ESC>"\\n"	{return '\n';}	
<ESC>"\\\\"	{return '\\';}	
<ESC>"\\\""	{return '\"';}	
"/*"		{ BEGIN (COMMENT); }

<COMMENT>"*/"	{ BEGIN (INITIAL); }
<COMMENT>"\n"	{ lineNumber++; }
<COMMENT>.

"//"		{ BEGIN (IGNORE); }
<IGNORE>"\n"    { lineNumber++; BEGIN (INITIAL); }
<IGNORE>.

"int"		{ MY type = UParser::INT; }
"short"		{ MY type = UParser::SHORT; }
"char"		{ MY type = UParser::CHAR; }
"float"		{ MY type = UParser::FLOAT; }
"double"	{ MY type = UParser::DOUBLE; }
"static"
"unsigned"
"signed"

";"		{ 
			if (MY index != -1) { MY sizes[MY index]=MY size; } 
			MY index=-1; MY size=0; MY type = UParser::UNKNOWN; 
		}

{WORD}		{ 
			int	i;
			if (MY index != -1) { MY error=1; yyterminate(); }
			for (i=0; i<MY sizeArray; i++)
			{
				if (strcmp (MY names[i], (char*) YYText()) ==0) break;
			}
			if (i==MY sizeArray)
			{
				BEGIN (IGNORE);
				YY_BREAK
			}
			if (MY type == UParser::UNKNOWN)
			{
				MY error=lineNumber; 
				yyterminate();
			}
			MY index=i; MY size =0;
		}

{HEX_INT}	{ 
			char	*begin;
			if (MY index == -1) 
			{ 
				MY error=lineNumber; 
				yyterminate(); 
			}
			if  (MY size >= MY sizes [ MY index ])
			{
				MY error=lineNumber; 
				yyterminate(); 
			}
			begin=(char*) YYText()+1;
			/* get rid of preceeding stuff. it can be a sign */
			while (*begin != 'X' && *begin !='x') begin++;
			begin++;
			switch (MY type)
			{
			case UParser::INT:
			case UParser::INT_ARRAY:
				((int*) (MY values[MY index]))[MY size] = 
					(int)strtol (begin, 0, 16);
				break;
			case UParser::SHORT:
			case UParser::SHORT_ARRAY:
				((short*) (MY values[MY index]))[MY size] = 
					(short) strtol (begin, 0, 16);
				break;
			default:
				MY error=lineNumber; 
				yyterminate();
			}
			MY size++;
		}
{OCT_INT}	{ 
			char	*begin;
			if (MY index == -1) 
			{ 
				MY error=lineNumber; 
				yyterminate(); 
			}
			if  (MY size >= MY sizes [ MY index ])
			{
				MY error=lineNumber; 
				yyterminate(); 
			}
			begin=(char*) YYText()+1;
			/* get rid of preceeding stuff. it can be a sign */
			while (*begin == '0') begin++;

			switch (MY type)
			{
			case UParser::INT:
			case UParser::INT_ARRAY:
				((int*) (MY values[MY index]))[MY size] = 
					(int)strtol (begin, 0, 8);
				break;
			case UParser::SHORT:
			case UParser::SHORT_ARRAY:
				((short*) (MY values[MY index]))[MY size] = 
					(short) strtol (begin, 0, 8);
				break;
			default:
				MY error=lineNumber; 
				yyterminate();
			}
			MY size++;
		}
{DEC_INT}	{ 
			char	*begin;
			if (MY index == -1) 
			{ 
				MY error=lineNumber; 
				yyterminate(); 
			}
			if  (MY size >= MY sizes [ MY index ])
			{
				MY error=lineNumber; 
				yyterminate(); 
			}
			begin=(char*) YYText();
			switch (MY type)
			{
			case UParser::INT:
			case UParser::INT_ARRAY:
				((int*) (MY values[MY index]))[MY size] = 
					(int)strtol (begin, 0, 10);
				break;
			case UParser::SHORT:
			case UParser::SHORT_ARRAY:
				((short*) (MY values[MY index]))[MY size] = 
					(short) strtol (begin, 0, 10);
				break;
			default:
				MY error=lineNumber; 
				yyterminate();
			}
			MY size++;
		}
"\n"		{ lineNumber++; }
"["
"]"
"="
"\*"
"{"
"}"
","
.
