/*$Id: ap_error.cc,v 15.3 1999/09/17 17:27:00 al Exp $ -*- C++ -*-
 * Error handler.
 */
#include "ap.h"
#include "u_opt.h"
/*--------------------------------------------------------------------------*/
//	CS &	CS::check(int i, const std::string& s);
//	CS &	CS::warn(int i, int c, const std::string& s);
/*--------------------------------------------------------------------------*/
/* syntax_check: handle syntax errors
 * called on parsing an input string when nothing else matches.
 * if the rest of the line is nothing, just return
 * if comment, increment *cnt, so what is left is a valid comment string
 * otherwise, it is an error (the arrow pointing at the offending word)
 */
CS & CS::check(int badness, const std::string& message)
{
  skipbl();
  switch (peek()){
    case '\'':	_ok = true;  skip();	   break;
    case '\0':	_ok = true;		   break;
    default:	_ok = false; warn(badness, message); break;
  }
  return *this;
}
/*--------------------------------------------------------------------------*/
/* syntax_msg: print syntax error message
 * echo a portion of the input with an arrow pointing to the current place
 */
CS & CS::warn(int badness, int spot, const std::string& message)
{
  if (badness >= OPT::picky){
    {if (spot < 40){
      IO::error.form("%.60s\n", _cmd);
      IO::error.tab(spot);
    }else{
      IO::error.form("... %.56s\n", &_cmd[spot-36]);
      IO::error.tab(40);
    }}
    error(badness, "^ ? " + message + '\n');
  }
  return *this;
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
