// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_GenericList.cc,v 1.2 1999/03/09 20:54:41 dmartin Exp $
// 
//---------------------------------------------------------------------------
#include "IIRScram_GenericList.hh"
#include "IIR_ConstantInterfaceDeclaration.hh"
#include "IIR_TypeDefinition.hh"
#include "IIR_Identifier.hh"

IIRScram_GenericList::~IIRScram_GenericList() {}


void 
IIRScram_GenericList::_publish_vhdl(ostream &_vhdl_out) {
  IIR_ConstantInterfaceDeclaration* i;
  for(i = first(); i != NULL; ) {
    _vhdl_out << "  ";
    i->_publish_vhdl_decl(_vhdl_out);
    i = successor(i);
    if (i != NULL) {
      _vhdl_out << ";\n";
    }
  }
}

void
IIRScram_GenericList::_publish_cc_elaborate() {
  IIR_ConstantInterfaceDeclaration* i;
  for(i = first(); i != NULL; ) {
    i->_publish_cc_elaborate();
    i = successor(i);
  }
}

void
IIRScram_GenericList::_publish_cc_elaborate_as_pointers(IIR_Boolean publishDefinition) {
  IIR_ConstantInterfaceDeclaration* i;
  
  for(i = first(); i != NULL; ) {
    i->_publish_cc_elaborate_as_pointers(publishDefinition);
    i = successor(i);
  }
}

void
IIRScram_GenericList::_publish_cc_copy_generics_to_globals() {
  IIR_ConstantInterfaceDeclaration* genericClause = first();

  ASSERT ( genericClause != NULL );
  
  _cc_out << "  if (::";
  genericClause->_get_declarator()->_publish_cc();
  _cc_out << "_info != &";
  genericClause->_get_declarator()->_publish_cc();
  _cc_out << "_info)  {\n";

  if (genericClause->_get_declarative_region()->get_kind() !=
      IIR_ENTITY_DECLARATION) {
    _cc_out << "    if (enclosingScope != NULL)  {\n"
	    << "       enclosingScope->copyGenericsToGlobals();\n"
	    << "    }\n";
  }
  
  do {
    _cc_out << "    ::";
    genericClause->_get_declarator()->_publish_cc();
    _cc_out << "_info = &";
    genericClause->_get_declarator()->_publish_cc();
    _cc_out << "_info;\n";

    genericClause = successor(genericClause);
  } while (genericClause != NULL);
  
  _cc_out << "  }\n";
}
  
void
IIRScram_GenericList::_publish_generic_parameter_list() {
  IIR_ConstantInterfaceDeclaration* i;
  for(i = first(); i != NULL; ) {
    i->get_subtype()->_publish_cc_elaborate();
    _cc_out << "  ";
    i->_get_declarator()->_publish_cc_elaborate();
    _cc_out << "_arg";
    i = successor(i);
    if(i!= NULL) {
      _cc_out << " ,\n";
    }
  }
}

void
IIRScram_GenericList::_publish_generic_parameters_notypes() {
  IIR_ConstantInterfaceDeclaration* i;
  for(i = first(); i != NULL; ) {
    i->_get_declarator()->_publish_cc_elaborate();
    _cc_out << "_arg";
    i = successor(i);
    if(i!= NULL) {
      _cc_out << " ,\n";
    }
  }
}

void
IIRScram_GenericList::_publish_generic_init()  {
  IIR_ConstantInterfaceDeclaration* i = NULL;
  for(i = first(); i != NULL; ) {
    if(_get_currently_publishing_unit() == IIRScram::ENTITY_DECL) {
      i->get_subtype()->_publish_cc_elaborate();
      _cc_out << " ";
    }
    
    i->_get_declarator()->_publish_cc_elaborate();
    _cc_out << "_info";
    i->_publish_cc_constructor_args();
    i = successor(i);
    if(_get_currently_publishing_unit() == IIRScram::ENTITY_DECL) {
      _cc_out << ";" << endl;
    }
    else {
      if(i != NULL) {
	_cc_out << ",\n";
      }
    }
  } 
}

void
IIRScram_GenericList::_publish_generic_init_by_arguments()  {
  IIR_ConstantInterfaceDeclaration* i;
  for(i = first(); i != NULL; ) {
    i->_get_declarator()->_publish_cc_elaborate();
    _cc_out << "_info(";
    i->_get_declarator()->_publish_cc_elaborate();
    _cc_out << "_arg)";
    i = successor(i);
    if(i != NULL) {
      _cc_out << ",\n";
    }
  }   
}

