//---------------------------------------------------------------------------
// Copyright (c) 1995-1999 Ohio Board of Regents and the University of
// Cincinnati.  All Rights Reserved.

// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

//---------------------------------------------------------------------------

#ifndef PHYSICALTYPE_HH
#define PHYSICALTYPE_HH

#include "TypeInfo.hh"
#include "ScalarType.hh"

class IntegerType;
class SavantstringType;

class PhysicalType: public ScalarType {
public:
  PhysicalType() : ScalarType() {}
  PhysicalType(ObjectBase::ObjectType);
  PhysicalType(ObjectBase::ObjectType, const UniversalLongLongInteger&);
  PhysicalType(ObjectBase::ObjectType, const PhysicalType&);
  PhysicalType(bool, const PhysicalType&);
  PhysicalType(const PhysicalType&);
  
  // The new constructors

  PhysicalType(ObjectBase::ObjectType, const phyInfo&);
  PhysicalType(ObjectBase::ObjectType, const TypeInfo &);
  PhysicalType(ObjectBase::ObjectType, 
	       const UniversalLongLongInteger&, const phyInfo&);
  PhysicalType(ObjectBase::ObjectType, const PhysicalType&, const phyInfo&);
  PhysicalType(bool, const PhysicalType&, const phyInfo&);
  PhysicalType(const PhysicalType&, const phyInfo&);

  virtual ~PhysicalType() {}

  PhysicalType& operator = (const PhysicalType&);

  Type get_kind() const;
  virtual const VHDLData& leftValue();

  static PhysicalType LEFT (const phyInfo &);
  static PhysicalType RIGHT(const phyInfo &);
  static PhysicalType HIGH (const phyInfo &);
  static PhysicalType LOW  (const phyInfo &);
  static EnumerationType ASCENDING (const phyInfo &);
  static PhysicalType      SUCC      (const PhysicalType&);
  static PhysicalType      PRED      (const IntegerType&);
  static PhysicalType      LEFTOF    (const PhysicalType&);
  static PhysicalType      RIGHTOF   (const PhysicalType&);
  static SavantstringType  IMAGE     (const PhysicalType&);
  static PhysicalType      VAL       (const PhysicalType&, const phyInfo &);
  static PhysicalType      VAL       (const IntegerType&, const phyInfo &);
  static IntegerType       POS       (const PhysicalType&, const phyInfo &);

  VTime getVTime() const;

  TypeInfo& getTypeInfo() const;
    
public:
  phyInfo range;

};

PhysicalType savantPlus(const PhysicalType&, const PhysicalType&);
PhysicalType savantMinus(const PhysicalType&, const PhysicalType&);
PhysicalType savantUnaryPlus(const PhysicalType&);
PhysicalType savantUnaryMinus(const PhysicalType&);
PhysicalType savantMultiply(const PhysicalType&, const IntegerType&);
PhysicalType savantMultiply(const PhysicalType&, const RealType&);
PhysicalType savantMultiply(const IntegerType&, const PhysicalType&);
PhysicalType savantMultiply(const RealType&, const PhysicalType&);
PhysicalType savantDivide(const PhysicalType&, const IntegerType&);
PhysicalType savantDivide(const PhysicalType&, const RealType&);
IntegerType savantDivide(const PhysicalType&, const PhysicalType&);
PhysicalType savantAbs(const PhysicalType&);

#endif
