/*C* -*-c++-*-
 *
 * Hatman - The Game of Kings
 * Copyright (C) 1997 James Pharaoh & Timothy Fisken
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *C*/

#ifndef vgaxx_Mouse_h
#define vgaxx_Mouse_h

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "Point.h"
#include "../util/Object.h"

#ifdef SVGALIB
#include "../util/Collection.h"
#endif

#include <sys/time.h>

class MouseEvent : public Object
{
public:
 Point p;
 MouseEvent(Point _p) { p = _p; }
};

class MouseMoveEvent : public MouseEvent { public: MouseMoveEvent(Point _p) : MouseEvent(_p) {}; };
class MouseLBDownEvent : public MouseEvent { public: MouseLBDownEvent(Point _p) : MouseEvent(_p) {}; };
class MouseRBDownEvent : public MouseEvent { public: MouseRBDownEvent(Point _p) : MouseEvent(_p) {}; };
class MouseLBUpEvent : public MouseEvent { public: MouseLBUpEvent(Point _p) : MouseEvent(_p) {}; };
class MouseRBUpEvent : public MouseEvent { public: MouseRBUpEvent(Point _p) : MouseEvent(_p) {}; };
class MouseDbClickEvent : public MouseEvent { public: MouseDbClickEvent(Point _p) : MouseEvent(_p) {}; };

class Mouse : public Object
{
#ifdef SVGALIB
private:
 Collection<MouseEvent>* eventQ;
 int pButton;
 friend void mouseHandler(int, int, int, int, int, int, int);
#endif

private:
 bool lastClick;
 Point lastClickPos;
 timeval lastClickTime;

private:
 Point pPosition;

public:
 class Sprite* sprite;

public:
 inline Point position() { return pPosition; }

public:
 Mouse();
 ~Mouse();

public:
 MouseEvent* getEvent();
};

#endif
