/*C* $Id: player.cc,v 1.6 1997/08/17 22:42:57 james Exp james $
 *
 * Hatman - The Game of Kings
 * Copyright (C) 1997 James Pharaoh & Timothy Fisken
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *C*/

#include "Data.h"
#include "Player.h"
#include "../gl/Aset.h"
#include "../gl/Animation.h"
#include "../gl/Console.h"
#include "../gl/VgaBlur.h"
#include "../util/util.h"

Player::Player()
{
 reset();
}

void Player::reset()
{
 score = 0;
 lives = 3;
 slowTime = 0;
 pause = 0;
 setPos(startPos);
}

void Player::setDir(Dir _dir)
{
 Actor::setDir(_dir);
 nextDir = None;
}

void Player::setPos(Pos _p)
{
 Actor::setPos(_p);
 nextDir = None;
}

void Player::draw()
{
 Point p = screenPos();
 if(p.x <= -sprW) p.x += vgaW; else if((p.x + sprW) >= vgaW) p.x -= vgaW;
 if(p.y <= -sprH) p.y += vgaH; else if((p.y + sprH) >= vgaH) p.y -= vgaH;
 Sprite* s = asetHatman->at(getDir())->next();
 screen->blur2(s->draw(screen, Point(p.x, p.y)));
 if(p.x < 0 || p.y < 0)
  {
   if(p.x < 0) screen->blur2(s->draw(screen, Point(p.x + vgaW, p.y)));
   if(p.y < 0) screen->blur2(s->draw(screen, Point(p.x, p.y + vgaH)));
  }
}

void Player::turnBack()
{
 Actor::turnBack();
}
